import { PluginFactory } from "./type";

export const StartPlugin: PluginFactory = () => ({
  onBeforeStart(context) {
    const { recorder, connection, config } = context;
    if (config.url) {
      recorder.start();
      connection.connect(config.url);
    }
  },
  onWsConnect(context) {
    const { connection, config } = context;
    if (config.url) {
      connection.connect(config.url);
    }
  },
  onStartAudio(context) {
    const { recorder } = context;
    recorder.start();
  },
  onStarted(context: any) {
    const { recorder, connection, timer, config } = context;
    timer.start();
    if (config.sendAudioDataWhenStarted) {
      recorder.on("dataAvailable", ({ data }: any) => {
        connection.send(data);
      });
    }
  },
});
