import { AudioRecorderConfig } from "../audio";
import { Connection, ConnectionOptions } from "../connection";
import { PluginFactory } from "../plugins";
import { Recorder } from "../recorder";
import type { SpeechRecognition } from "../speech-recognition";
import { Timer } from "../timer";

export interface Config {
  url?: string;
  connection?: ConnectionOptions;
  recorder?: AudioRecorderConfig;
  plugins?: Array<PluginFactory | { plugin: PluginFactory; config: Record<string, any> }>;
  sendAudioDataWhenStarted?: boolean;
}

interface ContextOptions {
  speechRecognition: SpeechRecognition;
  config?: Config;
}

export class Context {
  private _speechRecognition: SpeechRecognition;

  private _recorder = new Recorder();

  private _connection = new Connection();

  private _timer = new Timer();

  private _config: Config = {};

  get speechRecognition() {
    return this._speechRecognition;
  }

  get recorder() {
    return this._recorder;
  }

  get connection() {
    return this._connection;
  }

  get timer() {
    return this._timer;
  }

  get config() {
    return this._config;
  }

  constructor({ speechRecognition, config = {} }: ContextOptions) {
    this._speechRecognition = speechRecognition;
    this.updateConfig(config);
  }

  updateConfig = (config: Omit<Config, "plugins">) => {
    Object.assign(this.config, config);
  };
}
