# @tingwu/core-asr

听悟项目 ASR（自动语音识别）核心模块，提供实时语音识别和音频处理功能。

## 📦 安装

```bash
npm install @tingwu/core-asr
```

## 🎯 功能特性

- **音频录制**: 音频录制和采集
- **WebSocket 连接**: 实时语音识别连接管理
- **事件系统**: ASR 事件处理和分发
- **插件管理**: 插件系统支持
- **定时器**: 定时任务管理
- **语音识别**: 语音识别核心功能

## 📖 使用示例

```typescript
import { 
  SpeechRecognition,
  StartPlugin,
  NoSleepPlugin 
} from '@tingwu/core-asr';

// 创建语音识别实例
const speechRecognition = new SpeechRecognition({
  plugins: [
    StartPlugin,
    NoSleepPlugin,
  ],
  sendAudioDataWhenStarted: true,
});

// 开始语音识别
speechRecognition.start({ 
  url: 'wss://dashscope.aliyuncs.com/api-ws/v1/inference?api_key=your_token' 
});

// 停止语音识别
speechRecognition.stop();

// 销毁实例
speechRecognition.destroy();
```

## 🔧 开发

```bash
# 安装依赖
npm install

# 开发模式
npm run dev

# 构建
npm run build
```

## 📄 许可证

[GPL-3.0-or-later](../../LICENSE)

