import React from "react";
import { Tooltip, TYIcon } from "@tingwu/design";

interface IProps {
  title: string;
  type: string;
  fn?: () => void;
}

export default (props: IProps) => {
  const { title, type, fn } = props;

  return (
    <Tooltip title={title} align={{ offset: [0, -8] }}>
      <TYIcon type={type} className="operateItem" onClick={fn} style={{ fontSize: "20px" }} />
    </Tooltip>
  );
};
