export class Prepare {
  waitingResolve: undefined | ((value?: unknown) => void);

  waitingReject: undefined | ((reason?: any) => void);

  isResolved = false;

  isRejected = false;

  isFinished = false;

  waiting: Promise<unknown>;

  constructor() {
    this.waiting = new Promise((resolve, reject) => {
      this.waitingResolve = resolve;
      this.waitingReject = reject;
    });
  }

  resolve() {
    this.isResolved = true;
    this.isFinished = true;
    if (this.waitingResolve) {
      this.waitingResolve();
    }
  }

  reject(reason?: any) {
    this.isRejected = true;
    this.isFinished = true;
    if (this.waitingReject) {
      this.waitingReject(reason);
    }
  }
}
