export enum eSpeechRecognitionStatusType {
  IDLE = "IDLE", // 空闲
  STARTING = "STARTING", // 启动
  RECORDING = "RECORDING", // 录音中
  PAUSED = "PAUSED", // 暂停
  STOPPING = "STOPPING", // 停止
  ERROR = "ERROR", // 错误
}

export interface iTranscriptionWordsType {
  beginTime: number; // 开始时间
  endTime: number; // 结束时间
  text: string; // 文本内容
}

export interface iTranscriptionStashResultType {
  sentenceId: number; // 下一句话的句子ID
  words: iTranscriptionWordsType[];
  text: string; // 当前文本是否构成完整的句子
}

export interface iTranscriptionType {
  time: number; // 当前已处理的音频时长，单位是毫秒。
  sentenceId: number; // 句子ID
  sentenceEnd?: boolean; // 当前文本是否构成完整的句子
  text?: string; // 识别文本。
  words?: iTranscriptionWordsType[]; // 字时间戳信息
  // 语音识别的暂存结果，是暂未完成断句的下一句话信息。您需要将stashResult结果和上面的text结果拼接以便后续处理
  stashResult?: iTranscriptionStashResultType;
}

export interface iTranslateResultType {
  text: string; // 句子翻译结果
  sentenceId: number; // 翻译句子编号
  partial: boolean;
  beginTime: number; // 翻译句子的开始时间，单位为毫秒
  endTime: number; // 翻译句子的结束时间，单位为毫秒
}

export interface iTranscriptionsLangType {
  sourceLang: string; // 原始语种
  targetLang: string; // 目标语种
  translateResult: iTranslateResultType[]; // 翻译句子结果
}

export interface iUseSpeechRecognitionType {
  dataId: string; // 数据ID
  appId?: string; // 应用ID
  meetingJoinUrl: string; // 入URL: 实时转写websocket链接地址，包含鉴权token，直接连接即可
  postAgentRequest: (data: any) => any; // 发送请求的函数
  onMessage?: (data: any, context: any) => void; // 消息回调函数
  onErrorMessage?: (data: any) => void; // 消息回调函数
  onDataIdChange?: (dataId: string) => void; // 数据ID变更回调函数
}
