export interface MicrophoneOptions {
  updateInterval?: number;
  fftSize?: number;
  onVolumeChange?: (data: VolumeData) => void;
  threshold?: number;
  smoothing?: number;
  volumeScale?: number;
}

export interface VolumeData {
  volume: number;
  smoothedVolume: number;
  isSpeaking: boolean;
}

export interface MicrophoneHookReturn {
  volume: number;
  smoothedVolume: number;
  isListening: boolean;
  error: string | null;
  isSpeaking: boolean;
  startListening: () => Promise<void>;
  stopListening: () => void;
}

export interface AudioConstraints {
  echoCancellation?: boolean;
  noiseSuppression?: boolean;
  autoGainControl?: boolean;
}
