// 添加麦克风权限状态类型
export enum eMicrophonePermissionState {
  GRANTED = "granted", // 已授权
  DENIED = "denied", // 已拒绝
  PROMPT = "prompt", // 需要用户授权
  UNSUPPORTED = "unsupported", // 不支持麦克风
  UNKNOWN = "unknown", // 状态未知
}

// 添加麦克风权限hook返回类型
export interface MicrophonePermissionHookReturn {
  permission: eMicrophonePermissionState;
  isRequesting: boolean;
  error: string | null;
  checkPermission: () => Promise<eMicrophonePermissionState>;
  requestPermission: () => Promise<eMicrophonePermissionState>;
}
