import { proxy, useSnapshot } from "valtio";
interface Transcription {
  model: string;
  languageHints?: string[];
  diarizationEnabled: boolean;
  languageHintEnabled: boolean;
  diarizationSpeakerCount?: number;
  translationEnabled: boolean;
  translationTargetLang: string[];
}

// 定义 State 类型
interface State {
  submitLoading: boolean;
  transcription: Transcription;
  currentTaskIsMeeting: boolean;
  createTaskOutput: {
    dataId?: string;
    meetingJoinUrl: string;
    status?: number;
  };
  audio: {
    audioChannelMode: string;
  };
  curTaskErrorMsg: string;
}

const defaultState: State = {
  submitLoading: false,
  currentTaskIsMeeting: false,
  createTaskOutput: {
    dataId: "",
    meetingJoinUrl: "",
  },
  transcription: {
    model: "cn",
    languageHints: ["cn", "en"],
    diarizationEnabled: true,
    languageHintEnabled: true,
    diarizationSpeakerCount: 2,
    translationEnabled: true,
    translationTargetLang: ["en"],
  },
  audio: {
    audioChannelMode: "",
  },
  curTaskErrorMsg: "",
};

// 初始化状态
const state = proxy<State>({ ...defaultState });

// 自定义 Hook
export const useMeetingState = () => {
  const store = useSnapshot(state);

  const updateStore = (fn: (state: State) => void): void => {
    fn(state);
  };

  const resetStore = () => {
    Object.assign(state, defaultState);
  };

  return {
    store,
    updateStore,
    resetStore,
  };
};
