import { Button, Flex } from "antd";
import React, { FC, useMemo } from "react";
import { eMicrophonePermissionState, useMicrophonePermission } from "../../hooks";
import { type iMicrophonePermissionCheckPropsType } from "./index.type";
import { MicrophonePermissionCheckWrapper } from "./styled";

const MicrophonePermissionCheck: FC<iMicrophonePermissionCheckPropsType> = props => {
  const { onStartRecord = () => {} } = props;
  const { permission, requestPermission } = useMicrophonePermission();

  const isEnabled = useMemo(() => permission === eMicrophonePermissionState.GRANTED, [permission]);

  return (
    <MicrophonePermissionCheckWrapper>
      <div className="MicrophonePermissionCheck__Title">开启麦克风后开始录音</div>
      <div className="MicrophonePermissionCheck__Describe">
        请在弹出的浏览器提示中点击“允许”，以继续体验实时音频转写能力。
      </div>
      <Flex justify="center" align="center" gap={7}>
        <div className={`MicrophoneOpen__Tip ${isEnabled ? "MicrophoneOpen__Tip__Enabled" : ""}`} />
        <div
          className={`MicrophoneOpen__Describe ${isEnabled ? "MicrophoneOpen__Describe__Enabled" : ""}`}
        >
          {isEnabled ? "麦克风已启用" : "麦克风未启用"}
        </div>
        {isEnabled ? null : (
          <div className="MicrophoneOpen__Btn" onClick={requestPermission}>
            开启
          </div>
        )}
      </Flex>
      <Button type="primary" className="StartMicBtn" disabled={!isEnabled} onClick={onStartRecord}>
        开始录音
      </Button>
    </MicrophonePermissionCheckWrapper>
  );
};

const memoWrapper = React.memo(MicrophonePermissionCheck);

export { memoWrapper as MicrophonePermissionCheck };
