import styled from "styled-components";

export const AudioEffectExperienceWrapper = styled.div`
  /* border-radius-lg */
  border-radius: 8px;
  /* 中性色/color-bg-base */
  background: var(--Fill_Background_Light);
  box-sizing: border-box;
  /* 中性色/color-border-secondary */
  border: 1px solid var(--Line_Light);
  /* 阴影/box-shadow-secondary */
  box-shadow:
    0px 12px 24px -16px rgba(0, 0, 0, 0.06),
    0px 8px 40px 0px rgba(0, 0, 0, 0.12),
    0px 0px 1px 0px rgba(0, 0, 0, 0.04);
  width: 720px;

  .AudioEffectExperience__Title {
    box-sizing: border-box;
    height: 64px;
    border-bottom: 1px solid var(--Line_Light);
    padding: 0 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;

    &__Text {
      font-family: Menlo;
      font-size: 24px;
      font-weight: normal;
      line-height: 36px;
      text-align: center;
      letter-spacing: normal;
      /* 中性色/color-text */
      color: var(--Text_Primary);
    }
  }

  .AudioEffectExperience__Content {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    height: calc(100vh - 558px);
    overflow: auto;
    max-height: 324px;
    box-sizing: border-box;
    padding: 0 24px;

    &__Text {
      font-family: PingFang SC;
      font-size: 24px;
      font-weight: 500;
      line-height: 44px;
      text-align: center;
      letter-spacing: normal;
      /* Hello，可以听得见 */
      color: var(--Text_Primary);
    }

    &__LastText {
      color: var(--Text_Caption);
    }

    &__Description {
      font-family: PingFang SC;
      font-size: 16px;
      font-weight: normal;
      line-height: 28px;
      text-align: center;
      letter-spacing: normal;
      /* 中性色/color-text */
      color: var(--Text_Primary);
    }
  }

  .AudioEffectExperience__WholeText {
    padding: 0 24px;
    position: relative;
    height: calc(100vh - 558px);
    max-height: 324px;
    width: 100%;
    overflow-y: scroll;

    &__Content {
      padding: 16px 0;
      font-family: PingFang SC;
      font-size: 14px;
      font-weight: normal;
      line-height: 24px;
      letter-spacing: normal;
      /* 中性色/color-text */
      color: var(--Text_Primary);
      border-top: 1px dashed var(--Line_Light);

      &:first-child {
        padding-top: 20px;
        border-top: none;
      }
    }

    &__Text {
      margin-bottom: 4px;
    }

    &__Mask {
      width: 100%;
      position: sticky;
      z-index: 1;
      height: 64px;
      bottom: 0;
      left: 0;
      background: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 1) 100%);
    }
  }

  .AudioEffectExperience__Bottom {
    border-radius: 6px;
    height: 200px;
    margin: 0 12px 12px;
    width: calc(100% - 24px);
  }

  .AudioEffectExperience__Tabs {
    border-radius: 4px;
    /* 中性色/color-fill-tertiary */
    background: var(--Fill_Tertiary);
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 4px;

    &__Item {
      padding: 4px 12px;
      border-radius: 4px;
      font-family: PingFang SC;
      font-size: 14px;
      font-weight: normal;
      line-height: 24px;
      letter-spacing: normal;
      color: var(--Text_Primary);
      cursor: pointer;

      &__Active {
        background: var(--Fill_Background_Light);
        font-weight: 500;
      }
    }
  }

  .AudioEffectExperience__ControlsGroup {
    &__Icon {
      border-radius: 8px;
      background: var(--Fill_Background_Light);
      box-sizing: border-box;
      border: 1px solid var(--Line_Light);
      font-size: 24px;
      cursor: pointer;
      height: 40px;
      width: 40px;
      display: flex;
      justify-content: center;
      align-items: center;
      color: var(--Text_Primary);

      &:hover {
        background: var(--Fill_Brand_Background);
        box-sizing: border-box;
        /* 主题色/color-primary-border */
        border: 0px solid var(--Line_Brand_Light);
        color: var(--Text_Brand_Primary);
      }
    }

    &__Stop {
      border-radius: 8px;
      background: var(--Danger);
      box-sizing: border-box;
      color: var(--Text_White);
      cursor: pointer;
      font-size: 24px;
      height: 40px;
      width: 40px;
      display: flex;
      justify-content: center;
      align-items: center;
    }
  }
`;
