import styled from "styled-components";

export const Heading1 = styled.h1`
  display: block;
  margin-bottom: 14px;
  font-size: 2.5em;
`;

export const Heading2 = styled.h2`
  display: block;
  margin-bottom: 14px;
  font-size: 2em;
`;

export const Heading3 = styled.h3`
  display: block;
  margin-bottom: 14px;
  font-size: 1.5em;
`;

export const Heading4 = styled.h4`
  display: block;
  margin-bottom: 14px;
  font-size: 1.2em;
`;

export const Heading5 = styled.h5`
  display: block;
  margin-bottom: 14px;
  font-size: 1em;
`;

export const Heading6 = styled.h6`
  display: block;
  margin-bottom: 14px;
  font-size: 1em;
`;

export const Paragraph = styled.p`
  display: block;
  margin-bottom: 4px;
  margin-top: 0;
  font-size: 1em;
`;

export const StyledMarkdown = styled.div`
  font-size: 14px;
  width: fit-content;
  > *:last-child {
    margin-bottom: 0;
  }
`;

export const Image = styled.img`
  width: 100%;
`;

export const Strong = styled.span`
  display: inline;
  font-weight: bold;
`;

export const Emphasis = styled.span`
  display: inline;
  font-style: italic;
`;

export const Blockquote = styled.div`
  position: relative;
  border-left: 0.2em solid #dfe2e5;
  padding: 0.25em 0 0.25em 1em;
  margin: 1em 0;
  color: #999;
`;

export const Text = styled.span`
  display: inline;
  font-family: "PingFang SC";
  font-weight: normal;
  color: var(--Text_Caption);
`;

export const InlineCode = styled.span`
  display: inline-block;
  color: var(--Text_Caption);
  padding: 0.25em 0.5em;
  margin: 0;
  font-size: 0.85em;
  background-color: var(--Fill_Brand_Background);
  border-radius: 3px;
`;

export const Hr = styled.hr`
  width: 100%;
  height: 0;
  border: none;
  border-top: 1px solid var(--Line_Primary);
`;

export const Table = styled.table`
  border-collapse: collapse;
  thead {
    td {
      font-weight: bold;
    }
  }

  tbody {
    tr:nth-child(2n) {
      background-color: var(--Fill_Tertiary);
    }
  }

  td {
    border: 1px solid var(--Line_Primary);
    padding: 0.4em 0.6em;
  }
`;

export const UL = styled.ul`
  padding-left: 30px;
  list-style-type: disc;

  li::marker {
    color: #3f3f3f;
  }
`;

export const OL = styled.ol`
  padding-left: 30px;
  list-style-type: decimal;

  li::marker {
    color: #3f3f3f;
  }
`;

export const Code = styled.code`
  white-space: pre-wrap;
`;
