// import { Root } from 'mdast-util-from-markdown/lib';
import { MarkdownExtension, RootContent } from "./types";

export class MarkdownController {
  extensions: MarkdownExtension[] = [];

  setExtensions(extensions: MarkdownExtension[]) {
    this.extensions = extensions;
  }

  renderRoot(root: any) {
    return this.renderChildren(root.children);
  }

  renderChildren(children: RootContent[] | undefined) {
    if (children && children.length > 0) {
      return children.map(item => this.renderContent(item));
    }
    return null;
  }

  renderContent(content: RootContent) {
    if (this.extensions.length === 0) {
      return null;
    }
    let i = 0;

    const next = () => {
      if (i >= this.extensions.length) {
        return null;
      }

      const extension = this.extensions[i];
      i++;

      return extension.renderContent(this, content, next);
    };

    return next();
  }
}
