import { createRenderExtension } from "./base";
import { getTextAndFormulas, renderNodes } from "../formula/formula";

export const extText = createRenderExtension({
  renderContent(_controller, content, next) {
    if (content.type === "text") {
      const { value } = content;
      const nodes = getTextAndFormulas(value);

      return renderNodes(nodes);
    }
    return next();
  },
});
