import React from "react";
import { createRenderExtension } from "./base";
import { OL, Paragraph, UL } from "../styled";

export const extList = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "list") {
      const { ordered, children, start } = content;
      const childElems = children.map((child: any, index: number) => {
        if (child.type === "listItem") {
          return <li key={String(index)}>{controller.renderChildren(child.children)}</li>;
        } else {
          return (
            <Paragraph key={String(index)}>{controller.renderChildren(child.children)}</Paragraph>
          );
        }
      });

      if (ordered) {
        return <OL start={start ?? undefined}>{childElems}</OL>;
      } else {
        return <UL>{childElems}</UL>;
      }
    }
    return next();
  },
});
