import React from "react";
import { createRenderExtension } from "./base";

import { Emphasis, Strong } from "../styled";

export const extStrong = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "strong") {
      return <Strong>{controller.renderChildren(content.children)}</Strong>;
    }
    return next();
  },
});

export const extEmphasis = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "emphasis") {
      return <Emphasis>{controller.renderChildren(content.children)}</Emphasis>;
    }
    return next();
  },
});
