import React from "react";
import { createRenderExtension } from "./base";
import { Code, InlineCode, Text } from "../styled";

export const extInlineCode = createRenderExtension({
  renderContent(_controller, content, next) {
    if (content.type === "inlineCode") {
      return (
        <InlineCode>
          <Text>{content.value}</Text>
        </InlineCode>
      );
    } else if (content.type === "code") {
      return <Code>{content.value}</Code>;
    }
    return next();
  },
});

export const extHtml = createRenderExtension({
  renderContent(_controller, content, next) {
    if (content.type === "html") {
      // todo: 暂时先不支持html，后边根据实际情况再支持
      return null;
    }
    return next();
  },
});
