import React from "react";
import { createRenderExtension } from "./base";
import { Blockquote } from "../styled";

export const extBlockquote = createRenderExtension({
  renderContent(controller, content, next) {
    if (content.type === "blockquote") {
      return <Blockquote>{controller.renderChildren(content.children)}</Blockquote>;
    }
    return next();
  },
});
