// Jest config for tingwu-components package
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  rootDir: path.resolve(__dirname, '../..'),
  testMatch: ['<rootDir>/packages/tingwu-components/**/__tests__/**/*.test.{ts,tsx}'],
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      tsconfig: {
        jsx: 'react-jsx',
        esModuleInterop: true,
        allowSyntheticDefaultImports: true,
      },
    }],
  },
  moduleNameMapper: {
    '\\.(less|css)$': 'identity-obj-proxy',
  },
};

