export enum storageKeys {
  detailRightContentWidth = "kaidou-detail-Right-Content-Width",
  showedLiveSpeakerTip = "TINGWU-SDK-SHOWED-LIVE-SPEAKER-TIP",
  showedLiveEditWordTip = "TINGWU-SDK-SHOWED-LIVE-EDIT-WORD-TIP",
  showedOfflineEditWordTip = "TINGWU-SDK-SHOWED-OFFLINE-EDIT-WORD-TIP",

  // @deprecated
  showedMeetingSummaryExpander = "TINGWU-SDK-SHOWED-MEETING-SUMMARY-EXPANDER",
  // @deprecated
  showedSpeakerSummaryExpander = "TINGWU-SDK-SHOWED-SPEAKER-SUMMARY-EXPANDER",

  showedMeetingSummaryExpanderV2 = "TINGWU-SDK-SHOWED-MEETING-SUMMARY-EXPANDER-V2",
  showedSpeakerSummaryExpanderV2 = "TINGWU-SDK-SHOWED-SPEAKER-SUMMARY-EXPANDER-V2",
  showedAgendaSummaryExpanderV2 = "TINGWU-SDK-SHOWED-AGENDA-SUMMARY-EXPANDER-V2",
  showedNoAgendaSummaryTip = "TINGWU-SDK-SHOWED-NO-AGENDA-SUMMARY-TIP",
}

type Key = keyof typeof storageKeys;

export const myLocalStorage = {
  getItem(key: Key, needParse = true) {
    const id = storageKeys[key];
    const value = localStorage.getItem(id);
    return needParse ? value && JSON.parse(value) : value;
  },
  setItem(key: Key, value: any, needStringify = true) {
    const id = storageKeys[key];
    const stringifiedValue = needStringify ? JSON.stringify(value) : value;
    localStorage.setItem(id, stringifiedValue);
  },
  removeItem(key: Key) {
    const id = storageKeys[key];
    localStorage.removeItem(id);
  },
  isHasId(key: Key, id: string) {
    const value = this.getItem(key, false) || "";
    const valueArray = value ? value.split(",") : [];

    return valueArray.includes(id);
  },
  setItemById(key: Key, id: string) {
    const value = this.getItem(key, false) || "";
    const valueArray = value ? value.split(",") : [];
    const MAX_ITEMS = 5000;

    if (valueArray.includes(id)) {
      return;
    }

    if (valueArray.length > MAX_ITEMS) {
      valueArray.splice(0, valueArray.length - MAX_ITEMS + 1);
    }

    valueArray.push(id);
    this.setItem(key, valueArray.join(","), false);
  },
};
