export const getHighlightFragments = (text: string, keyword: string) => {
  const splits = text.split(keyword);
  const result: Array<{
    title: string;
    isKeyword: boolean;
  }> = [];
  splits.forEach((title, index) => {
    result.push({
      title,
      isKeyword: false,
    });
    if (index < splits.length - 1) {
      result.push({
        title: keyword,
        isKeyword: true,
      });
    }
  }, result);
  return result;
};
