import { isIntersectRanges, CommonRange } from '../range';

describe('range', () => {
  describe('isIntersectRanges', () => {
    it('should return true for overlapping ranges', () => {
      const range1: CommonRange = { start: 0, end: 10 };
      const range2: CommonRange = { start: 5, end: 15 };
      expect(isIntersectRanges(range1, range2)).toBe(true);
    });

    it('should return true for fully contained ranges', () => {
      const range1: CommonRange = { start: 0, end: 10 };
      const range2: CommonRange = { start: 2, end: 8 };
      expect(isIntersectRanges(range1, range2)).toBe(true);
    });

    it('should return true for adjacent ranges (touching)', () => {
      const range1: CommonRange = { start: 0, end: 10 };
      const range2: CommonRange = { start: 10, end: 20 };
      // Note: min(10, 20) = 10, max(0, 10) = 10, 10 > 10 is false
      expect(isIntersectRanges(range1, range2)).toBe(false);
    });

    it('should return false for non-overlapping ranges', () => {
      const range1: CommonRange = { start: 0, end: 10 };
      const range2: CommonRange = { start: 11, end: 20 };
      expect(isIntersectRanges(range1, range2)).toBe(false);
    });

    it('should return true when ranges are identical', () => {
      const range1: CommonRange = { start: 5, end: 10 };
      const range2: CommonRange = { start: 5, end: 10 };
      expect(isIntersectRanges(range1, range2)).toBe(true);
    });

    it('should handle reversed order ranges', () => {
      const range1: CommonRange = { start: 5, end: 15 };
      const range2: CommonRange = { start: 0, end: 10 };
      expect(isIntersectRanges(range1, range2)).toBe(true);
    });
  });
});

