// Jest config for tingwu-common package
// This extends the root jest config
const path = require('path');

const rootConfig = require('../../jest.config.js');

module.exports = {
  ...rootConfig,
  // Override rootDir to be relative to this package
  rootDir: path.resolve(__dirname, '../..'),
  // Only run tests for this package
  testMatch: ['<rootDir>/packages/tingwu-common/**/__tests__/**/*.test.{ts,tsx}'],
  // Setup files
  setupFilesAfterEnv: ['<rootDir>/jest.setup.js'],
  transform: {
    '^.+\\.(ts|tsx)$': ['ts-jest', {
      tsconfig: {
        esModuleInterop: true,
        allowSyntheticDefaultImports: true,
        jsx: 'react-jsx',
      },
    }],
  },
};

