# @tingwu/common

听悟项目通用工具库，提供基础的工具函数和工具类。

## 📦 安装

```bash
npm install @tingwu/common
```

## 🎯 功能特性

- **事件管理**: 事件发射器和监听器
- **选择操作**: DOM 选择相关工具
- **键盘处理**: 键盘事件和快捷键
- **日期时间**: 日期时间格式化工具
- **浏览器检测**: 浏览器环境检测
- **样式工具**: 样式相关工具函数
- **本地存储**: 本地存储封装
- **高亮功能**: 文本高亮工具
- **React Hooks**: 通用 React Hooks
- **文字处理**: 文字相关工具函数
- **范围操作**: 范围选择工具
- **剪贴板**: 剪贴板操作工具

## 📖 使用示例

```typescript
import { 
  useSyncEffect,
  isFirefox 
} from '@tingwu/common';

// React Hook - 同步副作用
useSyncEffect(() => {
  // 同步执行副作用
  console.log('同步执行');
}, [deps]);

// 浏览器检测
if (isFirefox()) {
  console.log('当前是 Firefox 浏览器');
}
```

## 🧪 测试

### 运行测试

**注意**: 在运行测试之前，请确保已在根目录安装了所有依赖：

```bash
# 在项目根目录运行
cd ../..
npm install
```

然后在 `tingwu-common` 目录下运行：

```bash
npm run test
```

或者从根目录运行所有包的测试：

```bash
# 在项目根目录
npm run test
```

> **遇到权限问题？** 如果遇到 npm 权限错误（EACCES），请参考 [修复 npm 权限问题文档](../../docs/FIX-NPM-PERMISSIONS.zh.md)

### 测试命令

- `npm run test`: 运行测试
- `npm run test:watch`: 监听模式运行测试
- `npm run test:coverage`: 生成覆盖率报告

## 🔧 开发

```bash
# 安装依赖
npm install

# 构建
npm run build

# 类型检查
npm run typechecking

# 代码检查
npm run lint
```

## 📄 许可证

[GPL-3.0-or-later](../../LICENSE)
