#!/bin/bash

# 修复 npm 和项目权限的脚本

echo "🔧 开始修复权限..."

# 获取当前用户和组
USER=$(whoami)
GROUP=$(id -gn)

echo "📁 修复 npm 缓存权限..."
sudo chown -R $USER:$GROUP ~/.npm

echo "📁 修复项目 node_modules 权限..."
PROJECT_DIR="/Users/leilei/Documents/project/project-tingwu/tingwu-web"

# 修复根目录 node_modules
if [ -d "$PROJECT_DIR/node_modules" ]; then
    echo "  修复根目录 node_modules..."
    sudo chown -R $USER:$GROUP "$PROJECT_DIR/node_modules"
    sudo chmod -R u+w "$PROJECT_DIR/node_modules"
fi

# 修复所有包的 node_modules
echo "  修复各包的 node_modules..."
for dir in "$PROJECT_DIR/packages"/*/node_modules; do
    if [ -d "$dir" ]; then
        echo "    修复: $dir"
        sudo chown -R $USER:$GROUP "$dir"
        sudo chmod -R u+w "$dir"
    fi
done

# 修复 .cache 目录
echo "  修复 .cache 目录..."
find "$PROJECT_DIR" -type d -name ".cache" -exec sudo chown -R $USER:$GROUP {} \; 2>/dev/null
find "$PROJECT_DIR" -type d -name ".cache" -exec sudo chmod -R 755 {} \; 2>/dev/null

echo "✅ 权限修复完成！"
echo ""
echo "现在可以运行:"
echo "  - npm install (如果需要)"
echo "  - npm run build (在各个包目录)"

