# Tingwu AI Intelligent Meeting Summary Example Application Development Documentation

[English Version](README-DEV.en.md) | [中文版本](README-DEV.md)

> **Note**: This document provides detailed development and technical details for the `tingwu-example` package.

## 🚀 Quick Start

### Requirements

- **Node.js**: Version ≥ 18.0.0

### Startup Steps

1. **Install Dependencies**

   ```bash
   npm install
   ```

2. **Configure API Keys**

   Edit the `.env` file and configure your API Key and App ID:

   ```typescript
   REACT_APP_API_KEY = xxxxx;
   REACT_APP_APP_ID = xxxxx;
   ```

3. **Start the Application**

   ```bash
   npm run dev
   ```

4. **Access the Application**

   Open your browser and visit: `http://localhost:3000`

## 📋 Feature Description

This example application demonstrates the core features of Tingwu AI Intelligent Meeting Summary:

<div align="center">
  <img src="./images/workflow.png" alt="Workflow" width="950">
</div>

### 🎵 Audio/Video File Upload

**Feature**: Upload audio or video files for automatic speech recognition and transcription

**Usage Flow**:

1. Click the "Select File" button and choose the audio/video file to upload
2. Upload the file to your own OSS or server
3. Create a task using `createTask`. Replace the `apiKey` and `appId` in the API call with your own. Customize the `parameters` and `analysis` parameters.

**Code Example**:

```javascript
const { output, code } = await createTaskAPI({
  input: {
    task: "createTask",
    type: "offline",
    fileUrl, // File link obtained after uploading to your own OSS or server
    appId: "your_APP_ID",
  },
  parameters: {
    transcription: {
      diarizationEnabled: true,
      diarizationSpeakerCount: 0,
      translationEnabled: false,
    },
    analysis: {},
  },
});
```

Step 4: Call `getTask` to get the task parsing status. The `dataId` parameter comes from the return value of the `createTask` API.

### 🎤 Real-time Recording

**Feature**: Real-time speech recognition, transcribing while speaking

Step 1: Start recording, verify browser microphone permissions, and ensure microphone permissions are enabled

Step 2: Create a task using `createTask`. Replace the `apiKey` and `appId` in the API call with your own. Customize the `parameters` and `analysis` parameters.

**Code Example**:

```javascript
const requestParams = {
  input: {
    task: "createTask",
    type: "realtime",
    format: "pcm",
    sampleRate: 16000,
    appId: "your_APP_ID",
  },
  parameters: {
    transcription: {
      model: language,
      diarizationEnabled: true,
      diarizationSpeakerCount: 0,
      translationTargetLang: "zh",
      translationEnabled: true,
    },
    analysis: {},
  },
};
```

Step 3: Establish WebSocket connection with heartbeat mechanism. If connection errors occur, reconnect up to 3 times, then stop reconnecting.

Two approaches: 1. WSS URL returned by the server 2. WSS URL concatenated by the frontend, token returned by the server. The demo uses the second approach. The token used is a temporary token, but temporary tokens only have a 1-minute validity period, so you need to re-obtain the temporary token after each disconnection and reconnection.

Step 4: Call `getTask` to get the task parsing status. The `dataId` parameter comes from the return value of the `createTask` API.

### 📄 Intelligent Meeting Summary Organization

**Feature**: View complete transcription results, summaries, Q&A, mind maps, and other capabilities

**Includes**:

- **Transcription Text**: Complete speech-to-text results
- **Speaker Separation**: Distinguish content from different speakers
- **Intelligent Summary**: Automatically generate content summaries
- **Q&A Review**: Extract key questions and answers
- **Chapter Overview**: Browse by time or content segments
- **Translation Feature**: Support multi-language translation (if enabled)

**Important Notes**:

- Text-type files do not support audio playback and backtracking features
- Configuration parameters need to be set when creating the task
- Supports custom analysis parameters

**Usage in Code**:

- Call `getTask` to get detail page data. The `dataId` parameter comes from the return value of the `createTask` API.
- Note: The `getTask` API does not return configuration parameters and file type. You need to set corresponding parameters based on the custom configuration options from the `createTask` API.
- Includes:
  - 1. Whether translation is enabled, source language, target language, whether original content rewriting is enabled, etc.
  - 2. File type settings: If it's text generation, the detail page does not display the audio area and does not support backtracking for chapter overview and Q&A review.
  - 3. Text types: "TEXT_FILE" or "TEXT_FILE_REUSE"

## 🔧 Development Guide

### Project Structure

```
tingwu-example/
├── src/
│   ├── App.tsx          # Main application component
│   ├── main.tsx         # Application entry point
│   └── index.css        # Style file
├── package.json         # Project configuration
└── vite.config.ts      # Vite configuration
```

### Main Dependencies

- **React 18**: Frontend framework
- **Ant Design**: UI component library
- **Vite**: Build tool
- **Tingwu Components**: Core feature components

### Development Commands

- `npm run dev`: Start development server
- `npm run build`: Build production version
- `npm run preview`: Preview build results
- `npm run lint`: Code linting

## ⚠️ Important Reminders

1. **API Configuration**: Must configure correct API Key and App ID before use
2. **Browser Permissions**: Real-time recording requires microphone permissions
3. **Network Environment**: Requires stable network connection to access Alibaba Cloud services
4. **HTTPS Requirement**: Production environment should use HTTPS protocol

