# Tingwu Web Project - System Architecture Diagram

[English Version](ARCHITECTURE.en.md) | [中文版本](ARCHITECTURE.md)

## Project Overview

Tingwu Web Project is a React application based on Monorepo architecture, using Lerna for multi-package management. The project provides core features including audio/video transcription, real-time recording, and intelligent meeting summaries.

## System Architecture Diagram

```mermaid
graph TB
    subgraph "Application Layer"
        Example["@tingwu/example<br/>Example App<br/>(Main Entry)"]
        Home["@tingwu/home<br/>Home App<br/>(Configuration Page)"]
    end

    subgraph "Feature Layer"
        Summary["@tingwu/summary<br/>Intelligent Summary Detail Page<br/>(DVA + Recoil)"]
        Transcription["@tingwu/transcription<br/>Transcription Module"]
        Sphere["@tingwu/sphere<br/>Feature Module"]
    end

    subgraph "Component Layer"
        Components["@tingwu/components<br/>UI Component Library<br/>(Markdown/QR etc.)"]
        MeetingIcon["@tingwu/meeting-icon<br/>Meeting Icon"]
    end

    subgraph "Core Layer"
        Core["@tingwu/core<br/>Core Logic<br/>(Controller/Model/Editor)"]
        CoreASR["@tingwu/core-asr<br/>ASR Core<br/>(Speech Recognition)"]
        Service["@tingwu/service<br/>API Service Layer"]
    end

    subgraph "Foundation Layer"
        Common["@tingwu/common<br/>Common Utilities<br/>(Hooks/Utils)"]
        Util["@tingwu/util<br/>Utility Functions"]
        Design["@tingwu/design<br/>Design System<br/>(Theme/Styles)"]
    end

    subgraph "External Services"
        AliyunAPI["Alibaba Cloud Bailian API<br/>(API Key + App ID)"]
    end

    %% Application Layer Dependencies
    Example --> Home
    Example --> CoreASR
    Example --> Summary
    Example --> Service
    Home --> Components
    Home --> Service
    Home --> Summary
    Home --> Design

    %% Feature Layer Dependencies
    Summary --> Common
    Summary --> Components
    Summary --> Core
    Summary --> Design
    Summary --> MeetingIcon
    Summary --> Service
    Summary --> Sphere
    Summary --> Transcription
    Summary --> Util

    Transcription --> Common
    Transcription --> Core
    Transcription --> Design
    Transcription --> MeetingIcon
    Transcription --> Sphere
    Transcription --> Util

    Sphere --> Common
    Sphere --> Core
    Sphere --> Design
    Sphere --> Util

    %% Component Layer Dependencies
    Components --> Common
    Components --> CoreASR
    Components --> Design
    Components --> Util

    %% Core Layer Dependencies
    Core --> Common
    CoreASR --> CoreASRModule["Independent Module (WebSocket/Recorder)"]

    %% Foundation Layer (No Internal Dependencies)
    Common --> CommonModule["React Hooks / Browser APIs / Utilities"]
    Util --> UtilModule["Utility Functions"]
    Design --> DesignModule["Theme System / Style Components"]

    %% External Service Connections
    Service --> AliyunAPI
    CoreASR --> AliyunAPI

    %% Styles
    classDef appLayer fill:#e1f5ff,stroke:#01579b,stroke-width:2px
    classDef featureLayer fill:#f3e5f5,stroke:#4a148c,stroke-width:2px
    classDef componentLayer fill:#e8f5e9,stroke:#1b5e20,stroke-width:2px
    classDef coreLayer fill:#fff3e0,stroke:#e65100,stroke-width:2px
    classDef foundationLayer fill:#fce4ec,stroke:#880e4f,stroke-width:2px
    classDef external fill:#ffebee,stroke:#b71c1c,stroke-width:2px

    class Example,Home appLayer
    class Summary,Transcription,Sphere featureLayer
    class Components,MeetingIcon componentLayer
    class Core,CoreASR,Service coreLayer
    class Common,Util,Design foundationLayer
    class AliyunAPI external
```

## Architecture Layer Description

### 1. Foundation Layer
Provides the most basic common functionality and utilities, with no dependencies on other internal packages.

- **@tingwu/common**: Common utilities and React Hooks
  - Browser API wrappers
  - Common utility functions
  - React Hooks (e.g., useSyncEffect)
  
- **@tingwu/util**: Pure utility function library
  - Collection of utility functions with no dependencies
  
- **@tingwu/design**: Design system
  - Theme configuration
  - Style components
  - Color system

### 2. Core Layer
Provides core business logic and service capabilities.

- **@tingwu/core**: Core business logic
  - Controller: Controller logic
  - Model: Data models
  - Editor: Editor functionality
  - Persist: Persistence
  
- **@tingwu/core-asr**: ASR (Automatic Speech Recognition) core
  - Audio recording
  - WebSocket connections
  - Speech recognition processing
  - Independent module with no dependencies on other internal packages
  
- **@tingwu/service**: API service layer
  - Encapsulates interactions with Alibaba Cloud Bailian API
  - HTTP request handling
  - Independent module

### 3. Component Layer
Provides reusable UI components.

- **@tingwu/components**: UI component library
  - Markdown rendering
  - QR code generation
  - Various business components
  
- **@tingwu/meeting-icon**: Meeting icon component

### 4. Feature Layer
Provides complete business feature modules.

- **@tingwu/summary**: Intelligent summary detail page
  - Uses DVA + Recoil for state management
  - Integrates multiple feature modules
  - Most complex business module
  
- **@tingwu/transcription**: Transcription feature module
  - Audio/video transcription processing
  
- **@tingwu/sphere**: Feature module
  - Specific business feature implementation

### 5. Application Layer
Final application entry points.

- **@tingwu/home**: Home application
  - Configuration page for starting intelligent summaries
  - Built with Vite
  
- **@tingwu/example**: Example application
  - Main startup entry
  - Route configuration
  - Integrates home and summary

## Technology Stack

### Build Tools
- **Lerna**: Monorepo management
- **Vite**: Application build tool
- **Father**: Library build tool
- **TypeScript**: Type system

### Frontend Framework
- **React 18**: UI framework
- **React Router**: Route management
- **Ant Design 5**: UI component library
- **Styled Components**: CSS-in-JS

### State Management
- **DVA**: Redux-based state management (summary module)
- **Recoil**: Atomic state management (summary module)
- **Valtio**: Proxy-based state management (components module)

### Core Features
- **WebSocket**: Real-time communication (ASR)
- **MediaRecorder API**: Audio recording
- **Alibaba Cloud Bailian API**: AI services

## Data Flow

```
User Actions
  ↓
Application Layer (example/home)
  ↓
Feature Layer (summary/transcription)
  ↓
Component Layer (components)
  ↓
Core Layer (core/core-asr/service)
  ↓
Foundation Layer (common/util/design)
  ↓
External Services (Alibaba Cloud Bailian API)
```

## Module Dependency Relationships

### Dependency Hierarchy (Bottom to Top)

1. **Foundation Layer** → No internal dependencies
2. **Core Layer** → Depends on Foundation Layer
3. **Component Layer** → Depends on Core Layer + Foundation Layer
4. **Feature Layer** → Depends on Component Layer + Core Layer + Foundation Layer
5. **Application Layer** → Depends on all lower layers

### Key Dependency Paths

- `example` → `home` → `summary` → `components` → `core` → `common`
- `example` → `core-asr` (independent)
- `summary` → `transcription` → `sphere` → `core` → `common`
- `components` → `core-asr` → WebSocket/Recorder

## Development Guidelines

1. **Foundation Layer**: Keep it pure, no dependencies on other internal packages
2. **Core Layer**: Focus on business logic, avoid UI-related code
3. **Component Layer**: Provide reusable UI components
4. **Feature Layer**: Integrate components and core logic to implement complete features
5. **Application Layer**: Responsible for routing and page organization

## Extensibility

- Add new feature modules: Add new packages in the Feature Layer
- Add new components: Add in the Component Layer
- Add new utilities: Add in the Foundation Layer
- Add new services: Add in the Core Layer

