# 听悟大模型前端项目

[English Version](README.en.md) | [中文版本](README.md)

## 📋 特性

本项目包含以下核心功能：

### 🎵 音视频文件上传

支持上传音频/视频文件进行离线转录

### 🎤 实时录音

支持实时语音识别和转录

### 📄 智能纪要结果页

- **实时录音智能纪要**: 用户实时发言的场景下，及时记录下用户发言的对应信息
  - 核心是基于前端的媒体技术，通过音频收集，音视频通信转写，自动帮用户转化为文字纪要
- **离线纪要整理**: 通过各类AI智能扩展，帮助用户高效快速的整理纪要
  - 当前支持2大类：1）实时录音智能纪要结束归档；2）本地音视频上传转写（其他离线纪要留档的形式）

<div align="center">
  
  ### 🌐 [在线体验 Live Demo](https://www.aliyun.com/exp/tingwu-agent)
  
  <img src="./docs/images/tingwu-agent.png" alt="核心功能介绍" width="950">
  
  <sub>点击上方链接体验完整功能，或查看下方截图了解核心特性</sub>
  
</div>

## 🚀 快速开始

### 1. 启动项目并查看效果

按照以下步骤启动项目：

#### 环境要求

- **Node.js**: 版本 ≥ 18.0.0
- **包管理器**: npm

#### 启动步骤

1. **克隆项目**
   拿到项目代码：git下载 或者 下载离线文件

2. **安装依赖**

   ```bash
   cd tingwu-web
   npm install
   ```

3. **配置 API 密钥**（重要！）

   编辑 `.env` 文件，将以下配置替换为你的实际值：

   ```typescript
   // TODO 修改成自己的API_KEY和APP_ID
   REACT_APP_API_KEY = xxxxx;
   REACT_APP_APP_ID = xxxxx;
   ```

4. **启动开发服务器**

   ```bash
   npm run start
   ```

5. **查看效果**

   打开浏览器访问：`http://localhost:3000`

   项目会自动打开浏览器并显示听悟大模型的前端界面。

### 2. 前置准备清单

在启动项目之前，需要完成以下准备工作：

| 步骤 | 操作说明             | 获取地址                                                                                              |
| ---- | -------------------- | ----------------------------------------------------------------------------------------------------- |
| 1    | **注册阿里云账号**   | [阿里云官网](https://www.aliyun.com)                                                                  |
| 2    | **开通百炼模型服务** | [百炼控制台](https://bailian.console.aliyun.com/?tab=model#/model-market)                             |
| 3    | **获取 API Key**     | [API Key 管理](https://bailian.console.aliyun.com/?tab=model#/api-key)                                |
| 4    | **获取 App ID**      | [应用管理](https://bailian.console.aliyun.com/?tab=app#/app/app-market/tingwu/tingwu-meeting-summary) |

#### 详细获取步骤

**API Key 获取步骤：**

1. 登录 [阿里云百炼控制台](https://bailian.console.aliyun.com/?tab=model#/api-key)
2. 在左侧导航栏选择 "API-KEY"
3. 点击 "创建新的 API Key"
4. 复制生成的 API Key

**App ID 获取步骤：**

1. 登录 [阿里云百炼控制台](https://bailian.console.aliyun.com/?tab=app#/app/app-market/tingwu/tingwu-meeting-summary)
2. 点击"创建应用" 生成自己的应用
3. 每个应用卡片都有 "应用 ID"

## 🔧 开发说明

### 项目结构

```
tingwu-web/
├── packages/
│   ├── tingwu-example/     # 示例应用（主要启动入口）
│   ├── @tingwu/service/     # API 服务层
│   ├── tingwu-components/  # 组件库
│   ├── @tingwu/core/       # 核心逻辑
│   ├── @tingwu/summary/       # 听悟智能纪要详情页
│   ├── @tingwu/home/       # 开启智能纪要的配置页
│   └── ...                # 其他包
```

### 主要命令

- `npm run start`: 启动开发服务器
- `npm run build`: 构建生产版本
- `npm run lint`: 代码检查
- `npm run test`: 运行测试

## ⚠️ 注意事项

1. **API 密钥安全**: 请勿将 API Key 提交到代码仓库，建议使用环境变量管理
2. **浏览器权限**: 实时录音功能需要浏览器麦克风权限
3. **网络要求**: 项目需要访问阿里云百炼服务，请确保网络连接正常
4. **⚠️ 重要说明**: 本项目的多包均未发布到 npm 公开库，如果开发使用，建议自己按需使用，如果需要发布 npm 包，需要自己重新命名

## 👨‍💻 开发者指南

如果你是开发者需要进行更多调试和深入了解代码实现，请查看：

- **[README-DEV.md](./docs/README-DEV.md)**: 详细的开发文档，包含代码调试、架构说明、API 接口等
- **[贡献指南](CONTRIBUTING.md)**: 了解如何参与项目贡献，包括开发环境设置、代码规范、提交规范等

## 🆘 常见问题

**Q: 启动后页面空白？**
A: 请检查是否已正确配置 API_KEY 和 APP_ID

**Q: 实时录音无法使用？**
A: 请确保浏览器已授权麦克风权限，并在 HTTPS 环境下使用

**Q: 文件上传失败？**
A: 请检查文件格式是否支持，以及 API 密钥是否有效

## 📞 技术支持

如有问题，请联系开发团队或查看项目文档。

## 🤝 参与贡献

我们欢迎所有形式的贡献！如果您想参与项目，请：

- 阅读 [贡献指南](CONTRIBUTING.md) ([English](CONTRIBUTING.en.md)) 了解如何参与贡献
- 查看 [行为准则](CODE_OF_CONDUCT.md) ([English](CODE_OF_CONDUCT.en.md)) 了解社区规范

## 📄 许可证

本项目是自由软件：您可以根据自由软件基金会发布的 GNU 通用公共许可证的条款重新分发和/或修改它，许可证版本 3，或（根据您的选择）任何更高版本。

完整的许可证文本请查看 [LICENSE](LICENSE) 文件。

SPDX-License-Identifier: GPL-3.0-or-later
