Tablestore CLI 提供简洁、方便的管理命令，支持 Windows、Linux、Mac 平台。本文介绍如何使用 Tablestore CLI 以命令行的方式管理表格存储。

# 配置
## 启动
```
# Welcome to use Command Line Tool for Aliyun Tablestore. Current Version is '2025-11-20'.
#    _______      _      _              _
#   |__   __|    | |    | |            | |
#      | |  __ _ | |__  | |  ___   ___ | |_   ___  _ __    ___
#      | | / _' || '_ \ | | / _ \ / __|| __| / _ \ | '__| / _ \
#      | || (_| || |_) || ||  __/ \__ \| |_ | (_) || |   |  __/
#      |_| \__,_||_.__/ |_| \___| |___/ \__| \___/ |_|    \___|
#
# Please visit our product website: https://www.aliyun.com/product/ots
# You can also join our DingTalk Chat Group (ID: 11789671 or 23307953) to discuss and ask Tablestore related questions.
#
tablestore>
```
## 配置
配置阿里云账号（AccessKeyId 和 AccessKeySecret）和 Tablestore 访问信息（实例和访问域名）
```
tablestore> config --endpoint http://cli-demo.cn-hangzhou.ots.aliyuncs.com --instance cli-demo --id xxxxxx --key xxxxxxxxx
done
```
如果还未创建 Tablestore 实例，则只需要配置阿里云账号（AccessKeyId 和 AccessKeySecret）
```
tablestore> config --id xxxxxx --key xxxxxxxxx
done
```
# 实例操作
## 服务开通
如果已经开通 Tablestore 服务，则可以直接跳过这步。服务仅需开通一次，开通过程完全免费。
```
tablestore@timeseries:tt0> enable_service
Your service is enabled.
```

## 创建实例
在 cn-hangzhou 区域创建一个测试实例 cli-demo，请注意实例名需要在区域内全局唯一。若出现实例名冲突错误，请重新取一个实例名称。
```
tablestore> create_instance -d "First instance created by CLI." -n cli-demo -r cn-hangzhou
done
```
## 查看实例
输入：
```
tablestore> describe_instance -r cn-hangzhou -n cli-demo
```
输出：
```
{
    "Status": 1,
    "WriteCapacity": 5000,
    "ReadCapacity": 5000,
    "ClusterType": "SSD",
    "Timestamp": "",
    "UserId": "643941",
    "InstanceName": "cli-demo",
    "CreateTime": "2021-10-31 14:19:43",
    "Network": "NORMAL",
    "Description": "First instance created by CLI.",
    "Quota": {
        "EntityQuota": 64
    },
    "TagInfos": {
        "TagInfo": []
    }
}
```
## 获取实例列表
输入：
```
tablestore> list_instance -r cn-hangzhou
```
输出：
```
[
    "cli-demo"
]
```
## 配置实例
输入：
```
tablestore> config --endpoint http://cli-demo.cn-hangzhou.ots.aliyuncs.com --instance cli-demo
```

- 实例的访问域名主要分为公网、VPC 两类，请根据实际需要来选择，域名的规则如下：
   - 公网：http://<instance_name>.<region_name>.ots.aliyuncs.com
   - VPC：http://<instance_name>.<region_name>.vpc.tablestore.aliyuncs.com

输出：
```
{
    "Endpoint": "http://cli-demo.cn-hangzhou.ots.aliyuncs.com",
    "AccessKeyId": "xxxxxxxxx",
    "AccessKeySecret": "xxxxxxxxxxxxxxxxxxx",
    "Instance": "cli-demo"
}
```
# 宽表操作
## 创建表
创建一张新表，该表的主键为 (uid string, pid integer)
```
tablestore> create -t mytable --pk '[{"c":"uid", "t":"string"}, {"c":"pid", "t":"integer"}]'
done
```


## 使用表
输入：
```
tablestore> use -t mytable
```
## 查看表信息
输入：
```
tablestore@widecolumn:mytable> desc
```
输出：
```
tablestore@widecolumn:mytable> desc
{
    "Name": "mytable",
    "Meta": {
        "Pk": [
            {
                "C": "uid",
                "T": "string",
                "Opt": "none"
            },
            {
                "C": "pid",
                "T": "integer",
                "Opt": "none"
            }
        ],
        "Defined": null
    },
    "Option": {
        "TTL": -1,
        "Version": 1
    },
    "CU": {
        "Read": 0,
        "Write": 0
    },
    "Stream": {
        "Enable": false,
        "Expire": 0
    },
    "Index": null
}
```
## 查看表列表
输入：
```
tablestore@widecolumn:mytable> ls
```
输出：
```
[
    "mytable"
]
```
## 插入新数据
插入一行新数据，插入的数据为 (uid="a", pid=0, b=0, c= false, d = "d")
```
tablestore@widecolumn:mytable> put --pk '["a", 0]' --attr '[{"c":"b", "v":0}, {"c":"c", "v":false}, {"c":"d", "v":"d"}]'
done
```
## 更新数据
更新一行数据，更新的数据为 (uid="b", pid=1, b=0, c=false, d="d")。
```
tablestore@widecolumn:mytable> update --pk '["b", 1]' --attr '[{"c":"b", "v":0}, {"c":"c", "v":false}, {"c":"d", "v":"d"}]'
done
```

- 该例子更新了一行不存在的数据，则会插入该行数据。



## 删除数据
删除一行数据，删除数据的主键为 (uid="c", pid=2)
```
tablestore@widecolumn:mytable> delete --pk '["c", 2]'
done
```

- 该例子删除一行不存在的数据，行为是允许的，返回删除成功。



## 扫描数据
输入：
```
tablestore@widecolumn:mytable> scan --limit 10
```

- 扫描获取整表数据，范围限制 10 行。



输出：
```
+-----+-----+---+-------+---+
| uid | pid | b | c     | d |
+-----+-----+---+-------+---+
| a   | 0   | 0 | false | d |
+-----+-----+---+-------+---+
| b   | 1   | 0 | false | d |
+-----+-----+---+-------+---+
Total count of rows: 2
```
# 多元索引
## 创建多元索引
```
tablestore@widecolumn:mytable> create_search_index -n search_index
Please input index schema:
{
     "IndexSetting": null,
     "FieldSchemas": [{
         "FieldName": "uid",
         "FieldType": 4,
         "Index": true,
         "EnableSortAndAgg": true,
         "Store": true
     }, {
         "FieldName": "pid",
         "FieldType": 1,
         "Index": true,
         "EnableSortAndAgg": true,
         "Store": true
     }, {
         "FieldName": "b",
         "FieldType": 1,
         "Index": true,
         "EnableSortAndAgg": true,
         "Store": true
     }, {
         "FieldName": "c",
         "FieldType": 3,
         "Index": true,
         "EnableSortAndAgg": true,
         "Store": true
     }, {
         "FieldName": "d",
         "FieldType": 4,
         "Index": true,
         "EnableSortAndAgg": true,
         "Store": true
     }]
 }
```
## 查看多元索引列表
输入：
```
tablestore@widecolumn:mytable> list_search_index
```
输出：
```
[
    "search_index"
]
```
## 查看多元索引信息
输入：
```
tablestore@widecolumn:mytable> describe_search_index -n search_index
```
输出：
```
{
    "IndexSetting": {
        "RoutingFields": null
    },
    "FieldSchemas": [
        {
            "FieldName": "uid",
            "FieldType": 4,
            "Index": true,
            "IndexOptions": null,
            "Analyzer": null,
            "AnalyzerParameter": null,
            "EnableSortAndAgg": true,
            "Store": true,
            "IsArray": null,
            "FieldSchemas": null,
            "IsVirtualField": null,
            "SourceFieldNames": null
        },
        {
            "FieldName": "pid",
            "FieldType": 1,
            "Index": true,
            "IndexOptions": null,
            "Analyzer": null,
            "AnalyzerParameter": null,
            "EnableSortAndAgg": true,
            "Store": true,
            "IsArray": null,
            "FieldSchemas": null,
            "IsVirtualField": null,
            "SourceFieldNames": null
        },
        {
            "FieldName": "b",
            "FieldType": 1,
            "Index": true,
            "IndexOptions": null,
            "Analyzer": null,
            "AnalyzerParameter": null,
            "EnableSortAndAgg": true,
            "Store": true,
            "IsArray": null,
            "FieldSchemas": null,
            "IsVirtualField": null,
            "SourceFieldNames": null
        },
        {
            "FieldName": "c",
            "FieldType": 3,
            "Index": true,
            "IndexOptions": null,
            "Analyzer": null,
            "AnalyzerParameter": null,
            "EnableSortAndAgg": true,
            "Store": true,
            "IsArray": null,
            "FieldSchemas": null,
            "IsVirtualField": null,
            "SourceFieldNames": null
        },
        {
            "FieldName": "d",
            "FieldType": 4,
            "Index": true,
            "IndexOptions": null,
            "Analyzer": null,
            "AnalyzerParameter": null,
            "EnableSortAndAgg": true,
            "Store": true,
            "IsArray": null,
            "FieldSchemas": null,
            "IsVirtualField": null,
            "SourceFieldNames": null
        }
    ],
    "IndexSort": {
        "Sorters": [
            {
                "Name": "PrimaryKeySort",
                "Sorter": {
                    "Order": 0
                }
            }
        ]
    }
}
```
## 查询多元索引
输入：
```
tablestore@widecolumn:mytable> search -n search_index --return_all_indexed
Please input query:
...{
...     "Offset": -1,
...     "Limit": 10,
...     "Collapse": null,
...     "Sort": null,
...     "GetTotalCount": true,
...     "Token": null,
...     "Query": {
...         "Name": "TermQuery",
...         "Query": {
...             "FieldName": "uid",
...             "Term": "a"
...         }
...     },
...     "Aggregations": [{
...         "Name": "avg",
...         "Aggregation": {
...             "AggName": "agg1",
...             "Field": "pid"
...         }
...     }]
... }
```
输出：
```
Perform search query:
{"Offset":-1,"Limit":10,"Collapse":null,"Sort":null,"GetTotalCount":true,"Token":null,"Query":{"Name":"TermQuery","Query":{"FieldName":"uid","Term":"a"}},"Aggregations":[{"Name":"avg","Aggregation":{"AggName":"agg1","Field":"pid","MissingValue":null}}]}

+-----+-----+---+
| uid | pid | d |
+-----+-----+---+
| a   | 0   | d |
+-----+-----+---+
Total count of rows returned: 1.
Total count of rows matched: 1.

Aggregation results:
avg: {"Name":"agg1","Value":0}
```
## 删除多元索引
```
tablestore@widecolumn:mytable> drop_search_index -n search_index
done
```
# 通道操作
## 创建通道
```
tablestore@widecolumn:mytable> create_tunnel -n t1
New tunnel created, its id is '9933470d-8a5e-4972-a5b0-b7ae6f836460'.
```
## 获取通道信息
输入：
```
tablestore@widecolumn:mytable> describe_tunnel -n t1
```
输出：
```
Tunnel Info:
+--------------------------------------+------------+------------+---------------+---------+
| TunnelId                             | TunnelName | TunnelType | Stage         | Expired |
+--------------------------------------+------------+------------+---------------+---------+
| 9933470d-8a5e-4972-a5b0-b7ae6f836460 | t1         | Stream     | ProcessStream | false   |
+--------------------------------------+------------+------------+---------------+---------+

Channel Info:
+-------------------------------------------------------+-------------+---------------+----------+-------------------------------+
| ChannelId                                             | ChannelType | ChannelStatus | ClientId | ChannelRPO                    |
+-------------------------------------------------------+-------------+---------------+----------+-------------------------------+
| cfd2c05b-54b6-48ec-aa6f-feb427f0ca57_1635771329155688 | Stream      | OPEN          |          | 1970-01-01 08:00:00 +0800 CST |
+-------------------------------------------------------+-------------+---------------+----------+-------------------------------+
```
## 模拟消费通道
输入：
```
tablestore@widecolumn:mytable> consume_tunnel -n t1 -m mock_consume
```
输出：
```
Start to shadow copy channels. TotalCount: 1 OPEN: 1
{"Type":0,"Timestamp":1635863828224578,"SequenceInfo":{"Epoch":0,"Timestamp":1635863828224578,"RowIndex":1},"PrimaryKey":{"PrimaryKeys":[{"ColumnName":"uid","Value":"a"},{"ColumnName":"pid","Value":0}]},"Columns":[{"Type":0,"Name":"b","Value":0,"Timestamp":1635863828225},{"Type":0,"Name":"c","Value":false,"Timestamp":1635863828225},{"Type":0,"Name":"d","Value":"d","Timestamp":1635863828225}]}
{"Type":0,"Timestamp":1635863834906337,"SequenceInfo":{"Epoch":0,"Timestamp":1635863834906337,"RowIndex":1},"PrimaryKey":{"PrimaryKeys":[{"ColumnName":"uid","Value":"a"},{"ColumnName":"pid","Value":0}]},"Columns":[{"Type":0,"Name":"b","Value":0,"Timestamp":1635863834907},{"Type":0,"Name":"c","Value":false,"Timestamp":1635863834907},{"Type":0,"Name":"d","Value":"d","Timestamp":1635863834907}]}
Continue(yes/<enter>/no)?
```

- 通道里必须有增量数据才能消费，如果没有可以新插入几条数据试试。



## 删除通道
```
tablestore@widecolumn:mytable> drop_tunnel -n t0
done
```
# 时序表操作
## 创建表
输入：
```
tablestore> create -m timeseries -t tt0 --ttl 86400
```
## 使用表
输入：
```
tablestor> use --ts -t tt0
```
## 查看表信息
输入：
```
tablestore@timeseries:tt0> desc
```
输出：
```
{
    "Name": "tt0",
    "TimeseriesOption": {
        "TTL": 86400
    }
}
```
## 更新表信息
输入：
```
tablestore@timeseries:tt0> alter --ttl 2592000
```
## 写入数据
插入一行新的时序数据，该行数据为：

- measurement='network'
- data_source=''
- tags='["network","",["city=shanghai"]]'
- fields: f0=0, f1=false, f2="f"
```
tablestore@timeseries:tt0> putts --k '["network","",["city=shanghai"]]' --field '[{"c":"f0","v":0,"isint":true}, {"c":"f1","v":false,"isint":true}, {"c":"f2","v":"f","isint":true}]'
done
```
## 导入数据
输入：
```
tablestore@timeseries:tt0> import_timeseries --input /Users/zhaofeng.zhou/Downloads/influx-cpu-sample
```
导入数据文件格式为：
```
	cpu,hostname=host_0,region=cn-hangzhou usage_user=58i,usage_system=2i,usage_idle=24i 1609459200000000000
	cpu,hostname=host_1,region=cn-hangzhou usage_user=58i,usage_system=2i,usage_idle=24i 1609459200000000000
```

输出：
```
Current speed is: 4600 rows/s. Total succeed count 274400, failed count 0.
Current speed is: 6000 rows/s. Total succeed count 280400, failed count 0.
Current speed is: 7000 rows/s. Total succeed count 287400, failed count 0.
Import finished, total count is 288000, failed 0 rows.
```
## 查询数据
输入：
```
tablestore@timeseries:tt0> getts --k '["network","",["city=shanghai"]]'
```
输出：
```
+-------------+-------------+-------------------+------------------+----+-------+----+
| measurement | data_source | tags              | timestamp        | f0 | f1    | f2 |
+-------------+-------------+-------------------+------------------+----+-------+----+
| network     |             | ["city=shanghai"] | 1635692300350165 | 0  | false | f  |
+-------------+-------------+-------------------+------------------+----+-------+----+
```
## 查询时间线
输入：
```
tablestore@timeseries:tt0> qtm
```
输出：
```
+-------------+-------------+-------------------+-----------------------------+-------------+
| measurement | data_source | tags              | attributes                  | update_time |
+-------------+-------------+-------------------+-----------------------------+-------------+
| network     |             | ["city=shanghai"] | ["city=shanghai","test=t2"] | 0           |
+-------------+-------------+-------------------+-----------------------------+-------------+
1 rows returned
```
## 更新时间线
更新时间线，修改属性列值。
```
tablestore@timeseries:tt0> utm --k '["network","",["city=shanghai"]]' --attrs '["city=shanghai", "test=t3"]'
done
```
## 删除表
删除时序表
```
tablestore@timeseries:tt0> drop --table tt0 --ts
```
# SQL 操作
## 进入 SQL 模式
```
tablestore@widecolumn:mytable> sql
tablestore@SQL>
```

- 进入 SQL 模式后，可以输入 SQL 语句并展示结果，SQL 语句必须以 ';' 结尾。
- 其他命令暂时不可用，若要退出 SQL 模式，可以输入 'exit;'。


## 绑定表
```
tablestore@SQL> CREATE TABLE `mytable` (
...     `uid` VARCHAR(1024),
...     `pid` BIGINT(20),
...     `b` DOUBLE,
...     `c` BOOL,
...     `d` MEDIUMTEXT,
...     PRIMARY KEY(`uid`,`pid`)
... );
```

- 对于 WideColumn 类型表，需要先使用 SQL 来绑定表后才能进行查询。
- 对于 TimeSeries 类型表，元数据表和数据表默认会绑定，可直接查询。



## 获取表列表
输入：
```
tablestore@SQL> show tables;
```
输出：
```
+--------------------+
| Tables_in_cli-demo |
+--------------------+
| mytable            |
+--------------------+
| tt0                |
+--------------------+
| tt0::meta          |
+--------------------+
```

- mytable 为绑定的宽表
- tt0 为时序数据表，tt0::meta 为时序元数据表。



## 查看表信息
输入：
```
tablestore@SQL> describe mytable;
```
输出：
```
+-------+---------------+------+-----+-------+
| Field | Type          | Null | Key | Extra |
+-------+---------------+------+-----+-------+
| uid   | varchar(1024) | NO   | PRI |       |
+-------+---------------+------+-----+-------+
| pid   | bigint(20)    | NO   | PRI |       |
+-------+---------------+------+-----+-------+
| b     | double        | YES  |     |       |
+-------+---------------+------+-----+-------+
| c     | tinyint(1)    | YES  |     |       |
+-------+---------------+------+-----+-------+
| d     | mediumtext    | YES  |     |       |
+-------+---------------+------+-----+-------+
```


## 查询表
输入：
```
tablestore@SQL> select * from mytable;
```
输出：
```
+-----+-----+---+-------+---+
| uid | pid | b | c     | d |
+-----+-----+---+-------+---+
| a   | 0   | 0 | false | d |
+-----+-----+---+-------+---+
| b   | 1   | 0 | false | d |
+-----+-----+---+-------+---+
```
