#
#  Copyright Alibaba Group Holding Ltd.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

import sys
from operator import add
import logging
from pyspark.sql import SparkSession

# This application demonstrates how to write pyspark job with a simple word-count application.

if __name__ == "__main__":
    m = n + 1
    spark = SparkSession\
        .builder\
        .appName("PythonWordCount")\
        .getOrCreate()
    sc = spark.sparkContext
    lines = sc.parallelize(['Hello ~ I am from China ~ Where are you from ~', 'Hello ~ I am from Russia ~'])
    counts = lines.flatMap(lambda x: x.split(' ')).map(lambda x: (x, 1)).reduceByKey(add)
    output = counts.collect()
    print("Finished")
    spark.stop()
