/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyun.lindorm.ldspark.examples.udf;

import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;

public final class SimpleHiveUDAF extends UDAF {

    public static class UDAFAvgState {
        private int sum;
    }

    public static class AvgEvaluator implements UDAFEvaluator {

        UDAFAvgState state;

        public AvgEvaluator() {
            super();
            state = new UDAFAvgState();
            init();
        }

        public void init() {
            state.sum = 0;
        }

        public boolean iterate(Integer x, Integer y) {
            if (x != null) {
                state.sum += x;
            }
            if (y != null) {
                state.sum += y;
            }
            return true;
        }

        public UDAFAvgState terminatePartial() {
            return state.sum == 0 ? null : state;
        }

        public boolean merge(UDAFAvgState o) {
            if (o != null) {
                state.sum += o.sum;
            }
            return true;
        }

        public int terminate() {
            return state.sum == 0 ? null : state.sum;
        }
    }

}