#
#  Copyright Alibaba Group Holding Ltd.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

import sys
import os

# Notice1: You need to do the following step to complete the code modification:
# Step1: Please add a "__init__.py" to your project directory, your project will act as a module of launcher.py
# Step2: Please add current dir to sys.path, you should add the following code to your main file
current_dir = os.path.abspath(os.path.dirname(__file__))
sys.path.append(current_dir)
print("current dir in your_project: %s" % current_dir)
print("sys.path: %s \n" % str(sys.path))

import fileA
from moduleA import a
from moduleB import b


# Notice2: Move the code in `if __name__ == "__main__":` branch to a new defined main(argv) function,
# so that launcher.py in parent directory just call main(sys.argv)
def main(argv):
    print("Receive arguments: %s \n" % str(argv))

    print("current dir in main: %s \n" % os.path.abspath(os.path.dirname(__file__)))
    fileA.print_fileA()
    a.print_moduleA_fileA()
    b.print_moduleB()

    # Any spark related code here.
    #
    # from pyspark.sql import SparkSession
    # spark = SparkSession \
    #     .builder \
    #     .appName("PythonImportTest") \
    #     .getOrCreate()
    # print(spark.conf)
    # spark.stop()


if __name__ == "__main__":
    main(sys.argv)
