# 语音交互SDK说明

## 名词说明
P2T(Push To Talk): 按下按键开始说话，放开按键接收交互结果并播放。   
T2T(Tap To Talk): 轻点按钮，开始说话，停止说话后接收交互结果并播放。  
Duplex: 全双工模式，可语音打断，也支持TapToTalk。  
KWS_Duplex: 带唤醒功能的全双工模式，可语音打断，也支持TapToTalk。
  
## APP_CODE
02A: 通义千问（AEC+VAD） -> VoiceChat, 含VAD、AEC, 不含KWS, 可选RTC、WS  
02B: 星尘(AEC) -> 默认带RTC不带WS的VoiceChat，含内部AEC, 不含VAD、KWS, 可选RTC、WS, 星尘带RTC  
02C: 纯云端 -> 默认带RTC不带WS的VoiceChat，不含内部AEC、VAD、KWS, 可选RTC、WS  
02D: 含VAD -> 默认带RTC的VoiceChat，不含内部AEC，内部VAD, 可选RTC、WS  
02E: 完整本地功能 -> 含VAD、AEC、KWS, 可选RTC、WS  

## FUN_CODE
|FUN_CODE|        /            |          /             |                 |    内部模块     |                |          /          |         链路模式 |         /            |                     |  云端协议   |            |      /     |
|:------:|:-------------------:|:----------------------:|:---------------:|:--------------:|:--------------:|:-------------------:|:---------------:|:--------------------:|:------------------:|:----------:|:----------:|:----------:|
|        |23-20bit:<br>reserved|19bit:<br>内部Beamforming|18bit:<br>内部VAD|17bit:<br>内部AEC|16bit:<br>内部KWS|14-15bit:<br>reserved|13bit:<br>支持RTC|12bit:<br>支持Websocket|3-11bit:<br>reserved|2bit:<br>百炼|1bit:<br>NLS|0bit:<br>通义|
| 073007 |                     |                        | &#10003;        | &#10003;       | &#10003;       |                     | &#10003;        | &#10003;             |                    | &#10003;   | &#10003;   | &#10003;    |
| 063007 |                     |                        | &#10003;        | &#10003;       |                |                     | &#10003;        | &#10003;             |                    | &#10003;   | &#10003;   | &#10003;    |
| 003007 |                     |                        |                 |                |                |                     | &#10003;        | &#10003;             |                    | &#10003;   | &#10003;   | &#10003;    |
| 003004 |                     |                        |                 |                |                |                     | &#10003;        | &#10003;             |                    | &#10003;   |            |             |

## 生成物说明: 
V1.4.4-02E-20251126_Linux/  
│── bin        Linux下可执行程序  
│── demo       bin下可执行程序的源码, 用户编译需要另外加入其他三方库如json  
│── include    SDK接口需要的头文件  
│── lib  
│   └── libconversation.so    SDK成果物动态库  
│── demo  
│   └── convBaiLianApiDemo    BaiLian协议的SDK API代码测试程序  
│── resources       SDK运行需要的资源文件, 根据业务场景选择  
│── README.md       说明文件
└── release.note    版本迭代说明

### 测试程序运行: 
#### DEMO示例:  
> ./convBaiLianApiDemo --app_id mm_XXXXXX --workspace_id llm-XXXXXX --workspace resources_aec_vad_android/ --file asr_example.wav --mode duplex --debug_path ./tmp --audio_format opus --apikey XXXXXXXX  
#### DEMO参数说明:  
> --url: 默认wss://dashscope.aliyuncs.com/api-ws/v1/inference，可不填  
> --apikey: 阿里云百炼API Key鉴权凭证  
> --model: 阿里云百炼模型名称，固定为"multimodal-dialog"，可不填  
> --app_id: 客户创建的应用ID，必填  
> --workspace_id: 客户在阿里云百炼业务空间ID，必填  
> --mode: 交互模式，tap2talk，push2talk，duplex，kws_duplex，默认duplex
> --task_id: 用于自定义本次连接唯一标识，需要32位随机字符串，不填则内部随机生成  
> --workspace: AEC/VAD/KWS存储的资源文件路径，必填  
> --debug_path: 调试路径，用于存储日志和中间音频文件  
> --output_path: AI返回的音频数据存储路径，用于调试
> --file: 用户说话的音频文件路径
> --jpeg_file: 传递给AI的jpeg文件路径  
> --sr: 用户说话的采样率  
> --audio_format: 用户说话的音频传递给AI的音频格式，格式可以为pcm和opus  
> --voice: 发音人  
> --downstream_sr: AI说话的采样率  
> --downstream_audio_format: AI说话的音频数据格式，支持opu,pcm,opus  
> --downstream_bitrate: downstream_audio_format为opus时，可以设置码率  
> --downstream_frame_size: downstream_audio_format为opus时，可以设置帧长  
> --transmit_rate_limit: downstream_audio_format为opus时，可以设置发送速率  
> --enable_external_aec_module: 是否使用外部aec，1为外部aec并关闭内部aec, 0为默认使用内部aec  
> --enable_external_vad_module: 是否使用外部vad，1为外部vad并关闭内部vad, 0为默认使用内部vad  
> --enable_vad_module: 默认为1，当enable_external_vad_module:0时，设置enable_vad_module:0，则关闭本地vad启用云端vad  
> --log_level: 日志级别，可以设置为version, debug, info, warn, error, none  
> --message: 是否将日志信息通过回调送回给用户层，1为true，0为false  
> --threads: 并发数，用于测试多实例，默认1
> --simpleLog: 1则减少日志打印，默认0  

#### DEMO代码编译:
如果修改了示例代码demo/ConversationBaiLianApiDemo.cc，需要重新编译工具:  
> cd V1.4.4-02E-20251126_Linux/  
> g++ -o convBaiLianApiDemo demo/ConversationBaiLianApiDemo.cc demo/external/jsoncpp.cpp -I include/ -I demo/external/ -L lib/ -lconversation -lz -std=c++11 -pthread  

## 三方库说明
1. OpenSSL 1.1.1d
2. ogg-1.3.2  
3. opus-1.2.1  

## TLS相关
### OpenSSL支持加密套件：
> Supported cipher suites:  
1 : TLS_AES_256_GCM_SHA384 - TLSv1.3  
2 : TLS_AES_128_GCM_SHA256 - TLSv1.3  
3 : RSA-PSK-AES256-GCM-SHA384 - TLSv1.2  
4 : AES256-GCM-SHA384 - TLSv1.2  
5 : AES256-CCM8 - TLSv1.2  
6 : AES256-CCM - TLSv1.2  
7 : PSK-AES256-GCM-SHA384 - TLSv1.2  
8 : PSK-AES256-CCM8 - TLSv1.2  
9 : PSK-AES256-CCM - TLSv1.2  
10 : RSA-PSK-AES128-GCM-SHA256 - TLSv1.2  
11 : AES128-GCM-SHA256 - TLSv1.2  
12 : AES128-CCM8 - TLSv1.2  
13 : AES128-CCM - TLSv1.2  
14 : PSK-AES128-GCM-SHA256 - TLSv1.2  
15 : PSK-AES128-CCM8 - TLSv1.2  
16 : PSK-AES128-CCM - TLSv1.2  
17 : AES256-SHA256 - TLSv1.2  
18 : AES128-SHA256 - TLSv1.2  
19 : RSA-PSK-AES256-CBC-SHA384 - TLSv1.0  
20 : RSA-PSK-AES256-CBC-SHA - SSLv3  
21 : AES256-SHA - SSLv3  
22 : PSK-AES256-CBC-SHA384 - TLSv1.0  
23 : PSK-AES256-CBC-SHA - SSLv3  
24 : RSA-PSK-AES128-CBC-SHA256 - TLSv1.0  
25 : RSA-PSK-AES128-CBC-SHA - SSLv3  
26 : AES128-SHA - SSLv3  
27 : PSK-AES128-CBC-SHA256 - TLSv1.0  
28 : PSK-AES128-CBC-SHA - SSLv3  

dashscope.aliyuncs.com 建连时使用的是 AES128-GCM-SHA256  

### Mbedtls支持加密套件：
> Supported cipher suites:  
1 : TLS1-3-AES-128-GCM-SHA256
2 : TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256
3 : TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256
4 : TLS-RSA-WITH-AES-128-GCM-SHA256
5 : TLS-ECDH-RSA-WITH-AES-128-GCM-SHA256
6 : TLS-ECDH-ECDSA-WITH-AES-128-GCM-SHA256
7 : TLS-RSA-PSK-WITH-AES-128-GCM-SHA256
8 : TLS-PSK-WITH-AES-128-GCM-SHA256

dashscope.aliyuncs.com 建连时使用的是 TLS1-3-AES-128-GCM-SHA256 TLSv1.3 
