grammar PartitionFilter;

root
   : expr EOF
   ;

expr
   : '(' expr ')' # DoNothing
   | IDENTITY IN '(' values ')' # InOp
   | IDENTITY comparisonOperator value  # CompareOp
   | IDENTITY REGEXP regex # RegexpOp
   | expr op=( AND|OR ) expr # LogicOp
   ;

values
   : (value ',')* value
   ;

comparisonOperator
    : '=' | '>' | '<' | '<=' | '>=' | '<>'
    ;

value
   : LITERAL
   ;
regex
   : REGEX
   ;

A : 'a' | 'A';
D : 'd' | 'D';
I : 'i' | 'I';
N : 'n' | 'N';
O : 'o' | 'O';
R : 'r' | 'R';
E : 'e' | 'E';
G : 'g' | 'G';
X : 'x' | 'X';
P : 'p' | 'P';

REGEXP : R E G E X P;
IN  : I N;
AND : A N D;
OR  : O R;

WHITESPACE : [ \t\r\n]+    -> skip;
IDENTITY   : [a-zA-Z_][a-zA-Z_0-9\u0080-\uFFFF]*;
LITERAL    : '\''([a-zA-Z_0-9\u0080-\uFFFF\-]+)'\''
           | '"'([a-zA-Z_0-9\u0080-\uFFFF\-]+)'"'
           | [0-9]+;
REGEX      : '/' .*? '/'
           ;
