/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.dw.newidea.reader.handle;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks_public20240518.models.GetProjectResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowMainSpec;
import com.aliyun.migration.spec.domain.dataworks.NodeMainSpec;
import com.aliyun.migration.spec.domain.dataworks.node.EndPoint;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.dw.newidea.reader.handle.AbstractDwIdeaHandler;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.DwNewideClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewIdeaOpenApiHandler
extends AbstractDwIdeaHandler {
    private static final Logger log = LoggerFactory.getLogger(DwNewIdeaOpenApiHandler.class);
    private DwNewideClient client;
    private String projectIdStr;

    public DwNewIdeaOpenApiHandler(Datasource datasource, TaskContext taskContext) {
        super(datasource, taskContext);
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        Map properties = scheduleDataSource.getProperties();
        this.projectIdStr = (String)properties.get("project");
        if (!NumberUtils.isDigits((String)this.projectIdStr)) {
            log.error("Project id is not number or not found");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PROJECT_CONF_NOT_FOUND);
        }
        String env_ak = System.getenv("LHM_DW_AK");
        String env_sk = System.getenv("LHM_DW_SK");
        if (StringUtils.isNotBlank((CharSequence)env_ak) && StringUtils.isNotBlank((CharSequence)env_sk)) {
            log.info("\u73af\u5883\u53d8\u91cf\u4e2d\u5b58\u5728ak\u3001sk\uff0c\u8986\u76d6\u914d\u7f6e\uff08\u5982\u65e0\u9700\u8986\u76d6\u8bf7unset LHM_DW_AK\u3001LHM_DW_SK\uff09");
            properties.put("ak", env_ak);
            properties.put("sk", env_sk);
        }
        this.client = new DwNewideClient((String)properties.get("ak"), (String)properties.get("sk"), null, (String)properties.get("endpoint"), EndPoint.getEndPoint((String)((String)properties.get("endpoint"))).getName());
    }

    @Override
    public WorkflowProjectPackage read() {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        GetProjectResponseBody.GetProjectResponseBodyProject projectInfo = this.client.getProject(this.projectIdStr);
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(projectInfo.getId().toString());
        workflowProject.setName(projectInfo.getName());
        workflowProject.setDescription(projectInfo.getDescription());
        workflowProjectPackage.setWorkflowProject(workflowProject);
        List wfMainSpecList = this.client.listWorkflowMainSpec(this.projectIdStr, Boolean.valueOf(true));
        ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
        HashMap<String, String> extraNodeOutputIdMap = new HashMap<String, String>();
        HashMap extraWorkflowOutputIdMap = new HashMap();
        List<Workflow> singleNodesBussiness = this.getSingleNodes(extraNodeOutputIdMap);
        workflowList.addAll(singleNodesBussiness);
        workflowList.addAll(CycleWorkflowMainSpec.getWorkflowList((List)wfMainSpecList, extraNodeOutputIdMap, extraWorkflowOutputIdMap));
        workflowProjectPackage.setWorkflowList(workflowList);
        for (Workflow bussiness : singleNodesBussiness) {
            if (!CollectionUtils.isNotEmpty((Collection)bussiness.getWorkflowNodes())) continue;
            bussiness.getWorkflowNodes().forEach(node -> this.client.getUpstreamNodeOutputs(this.projectIdStr, node.getNodeId()).forEach(upstreamNodeOutputs -> {
                if (extraNodeOutputIdMap.containsKey(upstreamNodeOutputs)) {
                    RelationPackage relationPackage = new RelationPackage();
                    relationPackage.setFrom((String)extraNodeOutputIdMap.get(upstreamNodeOutputs));
                    relationPackage.setTo(node.getNodeId());
                    relationPackage.setReType(RelationPackage.ReType.NODE);
                    bussiness.getNodeRelations().add(relationPackage);
                } else if (extraWorkflowOutputIdMap.containsKey(upstreamNodeOutputs)) {
                    RelationPackage relationPackage = new RelationPackage();
                    relationPackage.setFrom((String)extraWorkflowOutputIdMap.get(upstreamNodeOutputs));
                    relationPackage.setTo(node.getNodeId());
                    relationPackage.setReType(RelationPackage.ReType.WORKFLOW_NODE);
                    bussiness.getNodeRelations().add(relationPackage);
                }
            }));
        }
        for (Workflow workflow : workflowList) {
            workflow.setProjectId(workflowProject.getProjectId());
            workflow.setProjectName(workflowProject.getName());
            for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                workflowNode.setProjectId(workflowProject.getProjectId());
                workflowNode.setProjectName(workflowProject.getName());
            }
        }
        BwmConfiguration Configuration = BwmConfiguration.from((String)this.taskContext.getBwmConfiguration());
        if (Configuration.getBool("getDeployRecord") != null && Configuration.getBool("getDeployRecord").booleanValue()) {
            Map state = this.client.listPipelineState(this.projectIdStr);
            for (Workflow workflow : workflowList) {
                if (workflow.getIsBusiness() != null && workflow.getIsBusiness().booleanValue()) {
                    for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                        DwNewideClient.PipelineState pipelineState = (DwNewideClient.PipelineState)state.get(Long.parseLong(workflowNode.getNodeId()));
                        if (pipelineState != null) {
                            if (workflowNode.getCustomProperties() == null) {
                                workflowNode.setCustomProperties(new HashMap());
                            }
                            workflowNode.getCustomProperties().put("online.pipeline.state", JSONObject.toJSONString((Object)pipelineState, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
                            continue;
                        }
                        workflowNode.getCustomProperties().put("online.pipeline.state", "\u672a\u53d1\u5e03");
                    }
                    continue;
                }
                DwNewideClient.PipelineState pipelineState = (DwNewideClient.PipelineState)state.get(Long.parseLong(workflow.getWorkflowId()));
                if (pipelineState != null) {
                    if (workflow.getCustomProperties() == null) {
                        workflow.setCustomProperties(new HashMap());
                    }
                    workflow.getCustomProperties().put("online.pipeline.state", JSONObject.toJSONString((Object)pipelineState, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
                    continue;
                }
                workflow.getCustomProperties().put("online.pipeline.state", "\u672a\u53d1\u5e03");
            }
        } else {
            for (Workflow workflow : workflowList) {
                if (workflow.getCustomProperties() == null) {
                    workflow.setCustomProperties(new HashMap());
                }
                workflow.getCustomProperties().put("online.pipeline.state", "\u672a\u83b7\u53d6\u53d1\u5e03\u8bb0\u5f55");
            }
        }
        return workflowProjectPackage;
    }

    public void analyze(WorkflowProjectPackage pkg) {
    }

    public List<Workflow> getSingleNodes(Map<String, String> extraNodeOutputIdMap) {
        List result = this.client.getSingleNodes(this.projectIdStr);
        ArrayList nodeSingleSpec = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(node -> {
                NodeMainSpec nodeMainSpec = NodeMainSpec.getNodeMainSpec((String)node.getSpec());
                nodeSingleSpec.addAll(nodeMainSpec.getSpec());
            });
        }
        ArrayList cycleWorkflowNodes = new ArrayList();
        ArrayList manualWorkflowNodes = new ArrayList();
        if (CollectionUtils.isNotEmpty(nodeSingleSpec)) {
            nodeSingleSpec.forEach(node -> {
                WorkflowNode workflowNode = NodeSingleSpec.getWorkflowNode((NodeSingleSpec)node, (Boolean)true);
                if (node != null && node.getOutputs() != null && CollectionUtils.isNotEmpty((Collection)node.getOutputs().getNodeOutputs())) {
                    node.getOutputs().getNodeOutputs().forEach(nodeOutput -> extraNodeOutputIdMap.put(nodeOutput.getData(), node.getId()));
                }
                if (workflowNode != null && workflowNode.getTrigger() != null && StringUtils.equals((CharSequence)workflowNode.getTrigger().getType(), (CharSequence)"Manual")) {
                    manualWorkflowNodes.add(workflowNode);
                } else {
                    cycleWorkflowNodes.add(workflowNode);
                }
            });
        }
        Workflow workflow = new Workflow();
        workflow.setWorkflowId("DataWorks\u72ec\u7acb\u5468\u671f\u8282\u70b9\u96c6");
        workflow.setWorkflowName("DataWorks\u72ec\u7acb\u5468\u671f\u8282\u70b9\u96c6");
        workflow.setWorkflowNodes(cycleWorkflowNodes);
        workflow.setCategoryValue("");
        workflow.setIsBusiness(Boolean.valueOf(true));
        workflow.setNodeRelations(new ArrayList());
        Workflow workflow2 = new Workflow();
        workflow2.setWorkflowId("DataWorks\u72ec\u7acb\u624b\u52a8\u8282\u70b9\u96c6");
        workflow2.setWorkflowName("DataWorks\u72ec\u7acb\u624b\u52a8\u8282\u70b9\u96c6");
        workflow2.setWorkflowNodes(manualWorkflowNodes);
        workflow2.setCategoryValue("");
        workflow2.setIsBusiness(Boolean.valueOf(true));
        workflow2.setNodeRelations(new ArrayList());
        workflow2.setTriggers(List.of(new WorkflowTrigger()));
        ((WorkflowTrigger)workflow2.getTriggers().get(0)).setType("Manual");
        return List.of(workflow, workflow2);
    }
}

