/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.dw.newidea.reader.handle;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowMainSpec;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.dw.newidea.reader.handle.AbstractDwIdeaHandler;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewIdeaFileHandler
extends AbstractDwIdeaHandler {
    private static final Logger log = LoggerFactory.getLogger(DwNewIdeaFileHandler.class);

    public DwNewIdeaFileHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public WorkflowProjectPackage read() {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        List<CycleWorkflowMainSpec> specList = this.load();
        workflowProjectPackage.setWorkflowList(CycleWorkflowMainSpec.getWorkflowList(specList));
        workflowProjectPackage.setWorkflowProject(new WorkflowProject());
        workflowProjectPackage.getWorkflowProject().setName("CustomProject");
        workflowProjectPackage.getWorkflowProject().setProjectId("CustomProject");
        return workflowProjectPackage;
    }

    protected List<CycleWorkflowMainSpec> load() {
        Map properties = this.scheduleDataSource.getProperties();
        String packagePath = properties.getOrDefault("source-file-path", "temp/dolphinv1/");
        File rootDir = new File(packagePath);
        try {
            File dataDir = rootDir.isFile() ? ZipUtils.decompress((File)rootDir) : rootDir;
            log.info("load.file.success,dataDir:{}", (Object)dataDir.getAbsolutePath());
            ArrayList<CycleWorkflowMainSpec> specList = new ArrayList<CycleWorkflowMainSpec>();
            if (dataDir.exists() && dataDir.isDirectory()) {
                if (dataDir.listFiles().length == 1 && dataDir.listFiles()[0].getName().equals(dataDir.getName())) {
                    dataDir = dataDir.listFiles()[0];
                }
                if (dataDir.listFiles() != null) {
                    for (File file : dataDir.listFiles()) {
                        if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                        try {
                            String fileContent = FileUtils.readFileToString((File)file);
                            CycleWorkflowMainSpec spec = CycleWorkflowMainSpec.getWorkflowMainSpec((String)fileContent);
                            specList.add(spec);
                        }
                        catch (Exception e) {
                            log.error("Load File[{}] error {}", (Object)file.getName(), (Object)e);
                        }
                    }
                }
            }
            return specList;
        }
        catch (IOException e) {
            log.error("init.dolphin.export.error", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DOLPHIN_LOADER_FILE_FAILED);
        }
    }
}

