/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.spec.domain.dataworks.node;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResourceFileType {
    FLINK_JAR(-1, "FLINK_JAR", CalcEngineType.FLINK, LabelType.RESOURCE, List.of(".jar"), "Jar"),
    EMR_JAR(231, "EMR_JAR", CalcEngineType.EMR, LabelType.RESOURCE, List.of(".jar"), "Jar"),
    EMR_FILE(232, "EMR_FILE", CalcEngineType.EMR, LabelType.RESOURCE, new ArrayList<String>(), "File"),
    ODPS_FILE(15, "ODPS_FILE", CalcEngineType.ODPS, LabelType.RESOURCE, new ArrayList<String>(), "File"),
    ODPS_ARCHIVE(14, "ODPS_ARCHIVE", CalcEngineType.ODPS, LabelType.RESOURCE, List.of(".zip", ".tgz", ".tar.gz", ".tar"), "Archive"),
    ODPS_JAR(13, "ODPS_JAR", CalcEngineType.ODPS, LabelType.RESOURCE, List.of(".jar"), "Jar"),
    ODPS_PYTHON(12, "ODPS_PYTHON", CalcEngineType.ODPS, LabelType.RESOURCE, List.of(".py"), "Python"),
    CDH_JAR(274, "CDH_JAR", CalcEngineType.HADOOP_CDH, LabelType.RESOURCE, List.of(".jar"), "Jar"),
    CDH_FILE(275, "CDH_FILE", CalcEngineType.HADOOP_CDH, LabelType.RESOURCE, new ArrayList<String>(), "File");

    private static final Logger log;
    private final Integer code;
    private final String name;
    private final CalcEngineType calcEngineType;
    private final LabelType labelType;
    private final List<String> extension;
    private final String fileType;

    private ResourceFileType(int code, String name, CalcEngineType calcEngineType, LabelType labelType, List<String> extension, String fileType) {
        this.code = code;
        this.name = name;
        this.calcEngineType = calcEngineType;
        this.labelType = labelType;
        this.extension = extension;
        this.fileType = fileType;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public CalcEngineType getCalcEngineType() {
        return this.calcEngineType;
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public List<String> getExtension() {
        return this.extension;
    }

    public String getFileType() {
        return this.fileType;
    }

    public static ResourceFileType of(String name) {
        for (ResourceFileType resourceFileType : ResourceFileType.values()) {
            if (resourceFileType.getName().equals(name)) {
                return resourceFileType;
            }
            if (!resourceFileType.name().equals(name)) continue;
            return resourceFileType;
        }
        log.error("ResourceFileType not found: {}", (Object)name);
        return null;
    }

    static {
        log = LoggerFactory.getLogger(ResourceFileType.class);
    }
}

