/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.spec.domain.dataworks.node;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.spec.domain.dataworks.common.DatasourceSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ParamHubSpec;
import com.aliyun.migration.spec.domain.dataworks.common.RuntimeResourceSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ScriptSpec;
import com.aliyun.migration.spec.domain.dataworks.common.TriggerSpec;
import com.aliyun.migration.spec.domain.dataworks.common.metadata.MetadataSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.OutputBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.VariablesSpec;
import com.aliyun.migration.spec.domain.dataworks.node.BranchSpec;
import com.aliyun.migration.spec.domain.dataworks.node.ComponentSpec;
import com.aliyun.migration.spec.domain.dataworks.node.DowhileNodeSpec;
import com.aliyun.migration.spec.domain.dataworks.node.ForeachNodeSpec;
import com.aliyun.migration.spec.domain.dataworks.node.JoinSpec;
import com.aliyun.migration.spec.domain.dataworks.node.SubflowSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSingleSpec {
    private static final Logger log = LoggerFactory.getLogger(NodeSingleSpec.class);
    private String recurrence;
    private String id;
    private String name;
    private String owner;
    private String description;
    private Integer timeout;
    private String instanceMode;
    private String rerunMode;
    private Integer rerunTimes;
    private Integer rerunInterval;
    private ScriptSpec script;
    private TriggerSpec trigger;
    private RuntimeResourceSpec runtimeResource;
    private MetadataSpec metadata;
    private DatasourceSpec datasource;
    private DowhileNodeSpec dowhile;
    private ForeachNodeSpec foreach;
    private SubflowSpec subflow;
    private BranchSpec branch;
    private JoinSpec join;
    private ComponentSpec component;
    private OutputBatchSpec inputs;
    private OutputBatchSpec outputs;
    private ParamHubSpec paramHub;

    public static NodeSingleSpec getNodeSingleSpec(String nodeStr) {
        NodeSingleSpec nodeSingleSpec = (NodeSingleSpec)JSONObject.parseObject((String)nodeStr, NodeSingleSpec.class);
        JSONObject obj = JSONObject.parseObject((String)nodeStr);
        if (obj.containsKey("inputs")) {
            nodeSingleSpec.setInputs(OutputBatchSpec.getOutputBachSpec(((JSONObject)obj.get("inputs")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("outputs")) {
            nodeSingleSpec.setOutputs(OutputBatchSpec.getOutputBachSpec(((JSONObject)obj.get("outputs")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("do-while")) {
            nodeSingleSpec.setDowhile(DowhileNodeSpec.getDowhileNodeSpec(((JSONObject)obj.get("do-while")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("for-each")) {
            nodeSingleSpec.setForeach(ForeachNodeSpec.getForeachNodeSpec(((JSONObject)obj.get("for-each")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("subflow")) {
            nodeSingleSpec.setSubflow(SubflowSpec.getSubflowSpec(((JSONObject)obj.get("subflow")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("branch")) {
            nodeSingleSpec.setBranch(BranchSpec.getBranchSpec(((JSONObject)obj.get("branch")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("component")) {
            nodeSingleSpec.setComponent(ComponentSpec.getComponentSpec(((JSONObject)obj.get("component")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (obj.containsKey("param-hub")) {
            nodeSingleSpec.setParamHub(ParamHubSpec.getParamHubSpec(((JSONObject)obj.get("param-hub")).toJSONString(new JSONWriter.Feature[0])));
        }
        return nodeSingleSpec;
    }

    public static JSONObject getNodeSingleSpecJson(NodeSingleSpec nodeSingleSpec) {
        JSONObject jsonObject = JSONObject.from((Object)nodeSingleSpec);
        if (nodeSingleSpec.getInputs() != null) {
            jsonObject.put((Object)"inputs", (Object)OutputBatchSpec.getOutputBachSpecJson(nodeSingleSpec.getInputs()));
        } else {
            jsonObject.put((Object)"inputs", (Object)new JSONObject());
        }
        if (nodeSingleSpec.getOutputs() != null) {
            jsonObject.put((Object)"outputs", (Object)OutputBatchSpec.getOutputBachSpecJson(nodeSingleSpec.getOutputs()));
        } else {
            jsonObject.put((Object)"outputs", (Object)new JSONObject());
        }
        if (nodeSingleSpec.getDowhile() != null) {
            jsonObject.put((Object)"do-while", (Object)DowhileNodeSpec.getDowhileNodeSpecJson(nodeSingleSpec.getDowhile()));
            jsonObject.remove((Object)"dowhile");
        }
        if (nodeSingleSpec.getForeach() != null) {
            jsonObject.put((Object)"for-each", (Object)ForeachNodeSpec.getForeachNodeSpecJson(nodeSingleSpec.getForeach()));
            jsonObject.remove((Object)"foreach");
        }
        if (nodeSingleSpec.getSubflow() != null) {
            jsonObject.put((Object)"subflow", (Object)SubflowSpec.getSubflowSpecJson(nodeSingleSpec.getSubflow()));
        }
        if (nodeSingleSpec.getBranch() != null) {
            jsonObject.put((Object)"branch", (Object)BranchSpec.getBranchSpecJson(nodeSingleSpec.getBranch()));
        }
        if (nodeSingleSpec.getComponent() != null) {
            jsonObject.put((Object)"component", (Object)ComponentSpec.getComponentSpecJson(nodeSingleSpec.getComponent()));
        }
        if (nodeSingleSpec.getParamHub() != null) {
            jsonObject.put((Object)"param-hub", (Object)ParamHubSpec.getParamHubSpecJson(nodeSingleSpec.getParamHub()));
            jsonObject.remove((Object)"paramHub");
        }
        return jsonObject;
    }

    public static WorkflowNode getWorkflowNode(NodeSingleSpec node) {
        OutputBatchSpec inputs;
        List<VariablesSpec> variables;
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setCustomProperties(new HashMap());
        workflowNode.setRuntimeResource(new HashMap());
        workflowNode.setNodeName(node.getName());
        workflowNode.setNodeId(node.getId());
        workflowNode.setNodeType((String)node.getScript().getRuntime().get("command"));
        workflowNode.setOwner(node.getOwner());
        workflowNode.setDescription(node.getDescription());
        if (node.getDatasource() != null) {
            workflowNode.setDbType(node.getDatasource().getType());
            workflowNode.getCustomProperties().put("datasource", node.getDatasource().getName());
        }
        workflowNode.setScript(node.getScript().getContent());
        workflowNode.setDescription(node.getDescription());
        if (workflowNode.getParamMap() == null) {
            workflowNode.setParamMap(new HashMap());
        }
        if (node.getScript() != null && node.getScript().getParameters() != null && !node.getScript().getParameters().isEmpty()) {
            for (ScriptSpec.ScriptParameterSpec parameter : node.getScript().getParameters()) {
                if (StringUtils.equals((CharSequence)parameter.getName(), (CharSequence)"-") && StringUtils.equals((CharSequence)parameter.getValue(), (CharSequence)" ")) continue;
                workflowNode.getParamMap().put(parameter.getName(), parameter.getValue());
            }
        }
        WorkflowTrigger nodeTrigger = new WorkflowTrigger();
        if (node.getTrigger() != null) {
            if (node.getTrigger().getType() != null) {
                nodeTrigger.setType(node.getTrigger().getType());
            }
            if (node.getTrigger().getCron() != null) {
                nodeTrigger.setCron(node.getTrigger().getCron());
            }
            if (node.getTrigger().getStartTime() != null) {
                nodeTrigger.setStartTime(LocalDateTime.parse(node.getTrigger().getStartTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            if (node.getTrigger().getEndTime() != null) {
                nodeTrigger.setEndTime(LocalDateTime.parse(node.getTrigger().getEndTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            if (node.getTrigger().getTimezone() != null) {
                nodeTrigger.setTimezone(ZoneId.of(node.getTrigger().getTimezone()));
            }
        }
        if ((variables = (inputs = node.getInputs()).getVariables()) != null) {
            workflowNode.getCustomProperties().put("context.input", JSONObject.toJSONString(variables, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        workflowNode.setTrigger(nodeTrigger);
        workflowNode.setTimeout(node.getTimeout());
        if (StringUtils.equals((CharSequence)node.getInstanceMode(), (CharSequence)"T+1")) {
            workflowNode.setInstanceMode(WorkflowNode.InstanceMode.T_PLUS_1);
        } else if (StringUtils.equals((CharSequence)node.getInstanceMode(), (CharSequence)"Immediately")) {
            workflowNode.setInstanceMode(WorkflowNode.InstanceMode.IMMEDIATELY);
        }
        if (StringUtils.equals((CharSequence)node.getRerunMode(), (CharSequence)"Allowed")) {
            workflowNode.setRerunMode(WorkflowNode.RerunMode.ALL_ALLOWED);
        } else if (StringUtils.equals((CharSequence)node.getRerunMode(), (CharSequence)"Denied")) {
            workflowNode.setRerunMode(WorkflowNode.RerunMode.ALL_DENIED);
        } else if (StringUtils.equals((CharSequence)node.getRerunMode(), (CharSequence)"FailureAllowed")) {
            workflowNode.setRerunMode(WorkflowNode.RerunMode.FAILURE_ALLOWED);
        }
        if (StringUtils.isEmpty((CharSequence)node.getRecurrence())) {
            workflowNode.setState(WorkflowNode.Recurrence.NORMAL);
        } else if (StringUtils.equals((CharSequence)node.getRecurrence(), (CharSequence)"Normal")) {
            workflowNode.setState(WorkflowNode.Recurrence.NORMAL);
        } else if (StringUtils.equals((CharSequence)node.getRecurrence(), (CharSequence)"Skip")) {
            workflowNode.setState(WorkflowNode.Recurrence.SKIP);
        } else if (StringUtils.equals((CharSequence)node.getRecurrence(), (CharSequence)"Pause")) {
            workflowNode.setState(WorkflowNode.Recurrence.PAUSE);
        }
        workflowNode.getCustomProperties().put("auto.rerun.times", node.getRerunTimes());
        workflowNode.getCustomProperties().put("auto.rerun.interval.millis", node.getRerunInterval());
        workflowNode.getRuntimeResource().put("resource.group.identifier", node.getRuntimeResource().getResourceGroup());
        if (node.getScript() != null && node.getScript().getRuntime() != null && node.getScript().getRuntime().containsKey("cu")) {
            workflowNode.getRuntimeResource().put("workflow.schedule.cu", (String)node.getScript().getRuntime().get("cu"));
        }
        if (node.getScript() != null && node.getScript().getRuntime() != null && node.getScript().getRuntime().containsKey("container")) {
            if (node.getScript().getRuntime().get("container") instanceof JSONObject && ((JSONObject)node.getScript().getRuntime().get("container")).containsKey("imageId")) {
                workflowNode.getRuntimeResource().put("resource.group.image.id", ((JSONObject)node.getScript().getRuntime().get("container")).getString("imageId"));
            } else if (node.getScript().getRuntime().get("container") instanceof LinkedHashMap && ((LinkedHashMap)node.getScript().getRuntime().get("container")).containsKey("imageId")) {
                workflowNode.getRuntimeResource().put("resource.group.image.id", (String)((LinkedHashMap)node.getScript().getRuntime().get("container")).get("imageId"));
            }
        }
        if (workflowNode.getNodeType().equalsIgnoreCase(CodeProgramType.DI.name())) {
            JSONObject diScript = JSONObject.parseObject((String)node.getScript().getContent());
            if (diScript != null && diScript.containsKey("extend")) {
                String diResourceGroup;
                if (diScript.getJSONObject("extend").containsKey("resourceGroup")) {
                    diResourceGroup = diScript.getJSONObject("extend").getString("resourceGroup");
                    workflowNode.getRuntimeResource().put("di.resource.group.identifier", diResourceGroup);
                }
                if (diScript.getJSONObject("extend").containsKey("cu")) {
                    diResourceGroup = diScript.getJSONObject("extend").getString("cu");
                    workflowNode.getRuntimeResource().put("workflow.di.cu", diResourceGroup);
                }
            }
            Object sourceDatasource = "";
            String targetDatasource = "";
            String sourceDatasourceType = "";
            String targetDatasourceType = "";
            if (diScript != null && diScript.containsKey("steps")) {
                for (Object step : diScript.getJSONArray("steps")) {
                    JSONObject stepObj = (JSONObject)step;
                    if (!stepObj.containsKey("parameter")) continue;
                    JSONObject parameter = stepObj.getJSONObject("parameter");
                    if (stepObj.containsKey("category") && stepObj.getString("category").equals("reader")) {
                        String string = sourceDatasourceType = stepObj.containsKey("stepType") ? stepObj.getString("stepType") : "";
                        if (parameter.containsKey("datasource")) {
                            sourceDatasource = parameter.containsKey("datasource") ? parameter.getString("datasource") : "";
                            continue;
                        }
                        if (!parameter.containsKey("connection")) continue;
                        for (Object connection : parameter.getJSONArray("connection")) {
                            JSONObject connectionObj = (JSONObject)connection;
                            if (!connectionObj.containsKey("datasource")) continue;
                            if (StringUtils.isEmpty((CharSequence)sourceDatasource)) {
                                sourceDatasource = connectionObj.getString("datasource");
                                continue;
                            }
                            sourceDatasource = (String)sourceDatasource + " " + connectionObj.getString("datasource");
                        }
                        continue;
                    }
                    if (!stepObj.containsKey("category") || !stepObj.getString("category").equals("writer")) continue;
                    targetDatasourceType = stepObj.containsKey("stepType") ? stepObj.getString("stepType") : "";
                    targetDatasource = parameter.containsKey("datasource") ? parameter.getString("datasource") : "";
                }
            }
            workflowNode.setDbType(sourceDatasourceType + "," + targetDatasourceType);
            workflowNode.getCustomProperties().put("datasource", (String)sourceDatasource + "," + targetDatasource);
        }
        if (workflowNode.getNodeType().equals(CodeProgramType.SUB_PROCESS.getName())) {
            if (node.getSubflow() != null && !StringUtils.isEmpty((CharSequence)node.getSubflow().getId())) {
                workflowNode.setScript(node.getSubflow().getId());
            }
            if (node.getSubflow() != null && !StringUtils.isEmpty((CharSequence)node.getSubflow().getOutput()) && node.getSubflow().getOutput().endsWith("_out")) {
                String outputName = node.getSubflow().getOutput();
                workflowNode.setScript(outputName.substring(outputName.indexOf(".") + 1, outputName.length() - 4));
            }
        }
        if (workflowNode.getNodeType().equals(CodeProgramType.COMPONENT_SQL.getName()) && node.getComponent() != null) {
            if (workflowNode.getCustomProperties() == null) {
                workflowNode.setCustomProperties(new HashMap());
            }
            workflowNode.getCustomProperties().put("component", ComponentSpec.getComponentSpecJson(node.getComponent()).toJSONString(new JSONWriter.Feature[0]));
        }
        if (node.getOutputs() != null && node.getOutputs().getNodeOutputs() != null && !node.getOutputs().getNodeOutputs().isEmpty()) {
            node.getOutputs().getNodeOutputs().forEach(nodeOutput -> {
                if (nodeOutput.getData().endsWith("_out")) {
                    workflowNode.getCustomProperties().put("MigrationOriginalId", nodeOutput.getData().substring(nodeOutput.getData().indexOf(".") + 1, nodeOutput.getData().length() - 4));
                }
            });
        }
        return workflowNode;
    }

    public static WorkflowNode getWorkflowNode(NodeSingleSpec node, Boolean needCategoryValue) {
        WorkflowNode workflowNode = NodeSingleSpec.getWorkflowNode(node);
        if (needCategoryValue != null && needCategoryValue.booleanValue()) {
            workflowNode.setCategoryValue(node.getScript().getPath());
        }
        return workflowNode;
    }

    public void setRecurrence(String recurrence) {
        this.recurrence = recurrence;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setInstanceMode(String instanceMode) {
        this.instanceMode = instanceMode;
    }

    public void setRerunMode(String rerunMode) {
        this.rerunMode = rerunMode;
    }

    public void setRerunTimes(Integer rerunTimes) {
        this.rerunTimes = rerunTimes;
    }

    public void setRerunInterval(Integer rerunInterval) {
        this.rerunInterval = rerunInterval;
    }

    public void setScript(ScriptSpec script) {
        this.script = script;
    }

    public void setTrigger(TriggerSpec trigger) {
        this.trigger = trigger;
    }

    public void setRuntimeResource(RuntimeResourceSpec runtimeResource) {
        this.runtimeResource = runtimeResource;
    }

    public void setMetadata(MetadataSpec metadata) {
        this.metadata = metadata;
    }

    public void setDatasource(DatasourceSpec datasource) {
        this.datasource = datasource;
    }

    public void setDowhile(DowhileNodeSpec dowhile) {
        this.dowhile = dowhile;
    }

    public void setForeach(ForeachNodeSpec foreach) {
        this.foreach = foreach;
    }

    public void setSubflow(SubflowSpec subflow) {
        this.subflow = subflow;
    }

    public void setBranch(BranchSpec branch) {
        this.branch = branch;
    }

    public void setJoin(JoinSpec join) {
        this.join = join;
    }

    public void setComponent(ComponentSpec component) {
        this.component = component;
    }

    public void setInputs(OutputBatchSpec inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(OutputBatchSpec outputs) {
        this.outputs = outputs;
    }

    public void setParamHub(ParamHubSpec paramHub) {
        this.paramHub = paramHub;
    }

    public String getRecurrence() {
        return this.recurrence;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getInstanceMode() {
        return this.instanceMode;
    }

    public String getRerunMode() {
        return this.rerunMode;
    }

    public Integer getRerunTimes() {
        return this.rerunTimes;
    }

    public Integer getRerunInterval() {
        return this.rerunInterval;
    }

    public ScriptSpec getScript() {
        return this.script;
    }

    public TriggerSpec getTrigger() {
        return this.trigger;
    }

    public RuntimeResourceSpec getRuntimeResource() {
        return this.runtimeResource;
    }

    public MetadataSpec getMetadata() {
        return this.metadata;
    }

    public DatasourceSpec getDatasource() {
        return this.datasource;
    }

    public DowhileNodeSpec getDowhile() {
        return this.dowhile;
    }

    public ForeachNodeSpec getForeach() {
        return this.foreach;
    }

    public SubflowSpec getSubflow() {
        return this.subflow;
    }

    public BranchSpec getBranch() {
        return this.branch;
    }

    public JoinSpec getJoin() {
        return this.join;
    }

    public ComponentSpec getComponent() {
        return this.component;
    }

    public OutputBatchSpec getInputs() {
        return this.inputs;
    }

    public OutputBatchSpec getOutputs() {
        return this.outputs;
    }

    public ParamHubSpec getParamHub() {
        return this.paramHub;
    }
}

