/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.spec.domain.dataworks.node;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.migration.spec.domain.dataworks.common.metadata.MetadataSpec;
import com.aliyun.migration.spec.domain.dataworks.node.ComponentParam;
import java.util.List;

public class ComponentSpec {
    private String name;
    private String id;
    private String description;
    private String owner;
    private List<ComponentParam> inputs;
    private List<ComponentParam> outputs;
    private MetadataSpec metadata;

    public static ComponentSpec getComponentSpec(String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        ComponentSpec componentSpec = (ComponentSpec)JSONObject.parseObject((String)jsonStr, ComponentSpec.class);
        if (jsonObject.containsKey("inputs")) {
            componentSpec.setInputs(((JSONArray)jsonObject.get("inputs")).toJavaList(ComponentParam.class, new JSONReader.Feature[0]));
        }
        if (jsonObject.containsKey("outputs")) {
            componentSpec.setOutputs(((JSONArray)jsonObject.get("outputs")).toJavaList(ComponentParam.class, new JSONReader.Feature[0]));
        }
        return componentSpec;
    }

    public static JSONObject getComponentSpecJson(ComponentSpec componentSpec) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)componentSpec.getName());
        jsonObject.put((Object)"id", (Object)componentSpec.getId());
        jsonObject.put((Object)"description", (Object)componentSpec.getDescription());
        jsonObject.put((Object)"owner", (Object)componentSpec.getOwner());
        if (componentSpec.getInputs() != null) {
            jsonObject.put((Object)"inputs", (Object)JSONArray.from(componentSpec.getInputs()));
        }
        if (componentSpec.getOutputs() != null) {
            jsonObject.put((Object)"outputs", (Object)JSONArray.from(componentSpec.getOutputs()));
        }
        return jsonObject;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<ComponentParam> getInputs() {
        return this.inputs;
    }

    public List<ComponentParam> getOutputs() {
        return this.outputs;
    }

    public MetadataSpec getMetadata() {
        return this.metadata;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setInputs(List<ComponentParam> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(List<ComponentParam> outputs) {
        this.outputs = outputs;
    }

    public void setMetadata(MetadataSpec metadata) {
        this.metadata = metadata;
    }
}

