/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.oozie.client.BasicAuthenticator;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.XOozieClient;

public class AuthOozieClient
extends XOozieClient {
    public static final String AUTHENTICATOR_CLASS_SYS_PROP = "authenticator.class";
    public static final String USE_AUTH_TOKEN_CACHE_SYS_PROP = "oozie.auth.token.cache";
    public static final int AUTH_TOKEN_CACHE_FILENAME_MAXLENGTH = 255;
    private String authOption = null;
    private final File authTokenCacheFile;

    public AuthOozieClient(String oozieUrl) {
        this(oozieUrl, null);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="FilenameUtils is used to filter user input. JDK8+ is used.")
    public AuthOozieClient(String oozieUrl, String authOption) {
        super(oozieUrl);
        this.authOption = authOption;
        String filename = this.getAuthCacheFileName(oozieUrl);
        this.authTokenCacheFile = new File(System.getProperty("user.home"), FilenameUtils.getName((String)filename));
        if (filename.length() >= 255 && this.authTokenCacheFile.exists()) {
            System.out.println("Warn: the same Oozie auth cache filename exists, filename=" + filename);
        }
    }

    @VisibleForTesting
    public String getAuthCacheFileName(String oozieUrl) {
        String encodeBase64OozieUrl = Base64.getEncoder().encodeToString(oozieUrl.getBytes(StandardCharsets.UTF_8));
        String filename = ".oozie-auth-token-" + encodeBase64OozieUrl;
        if (filename.length() >= 255) {
            filename = filename.substring(0, 255);
        }
        return filename;
    }

    @Override
    protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
        long expires;
        AuthenticatedURL.Token currentToken;
        boolean useAuthFile = System.getProperty(USE_AUTH_TOKEN_CACHE_SYS_PROP, "false").equalsIgnoreCase("true");
        AuthenticatedURL.Token readToken = null;
        if (useAuthFile) {
            readToken = this.readAuthToken();
        }
        if ((currentToken = readToken == null ? new AuthenticatedURL.Token() : new AuthenticatedURL.Token(readToken.toString())).isSet() && (expires = AuthOozieClient.getExpirationTime(currentToken)) < System.currentTimeMillis() + 300000L) {
            if (useAuthFile) {
                this.authTokenCacheFile.delete();
            }
            currentToken = new AuthenticatedURL.Token();
        }
        if (currentToken.isSet()) {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("OPTIONS");
            AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)currentToken);
            if (conn.getResponseCode() == 401 || conn.getResponseCode() == 403) {
                if (useAuthFile) {
                    this.authTokenCacheFile.delete();
                }
                currentToken = new AuthenticatedURL.Token();
            } else {
                try {
                    AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)currentToken);
                }
                catch (AuthenticationException ex) {
                    if (useAuthFile) {
                        this.authTokenCacheFile.delete();
                    }
                    currentToken = new AuthenticatedURL.Token();
                }
            }
        }
        if (!currentToken.isSet()) {
            Authenticator authenticator = this.getAuthenticator();
            try {
                authenticator.authenticate(url, currentToken);
            }
            catch (AuthenticationException ex) {
                if (useAuthFile) {
                    this.authTokenCacheFile.delete();
                }
                throw new OozieClientException("AUTHENTICATION", "Could not authenticate, " + ex.getMessage(), ex);
            }
        }
        if (useAuthFile && currentToken.isSet() && (readToken == null || !currentToken.toString().equals(readToken.toString()))) {
            this.writeAuthToken(currentToken);
        }
        HttpURLConnection conn = super.createConnection(url, method);
        AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)currentToken);
        return conn;
    }

    private static long getExpirationTime(AuthenticatedURL.Token token) {
        String[] splits;
        long expires = 0L;
        for (String split : splits = token.toString().split("&")) {
            if (!split.startsWith("e=")) continue;
            try {
                expires = Long.parseLong(split.substring(2));
            }
            catch (Exception e) {
                break;
            }
        }
        return expires;
    }

    protected AuthenticatedURL.Token readAuthToken() {
        AuthenticatedURL.Token authToken = null;
        if (this.authTokenCacheFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.authTokenCacheFile), StandardCharsets.UTF_8));
                String line = reader.readLine();
                reader.close();
                if (line != null) {
                    authToken = new AuthenticatedURL.Token(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return authToken;
    }

    protected void writeAuthToken(AuthenticatedURL.Token authToken) {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            File tmpTokenFile = File.createTempFile(".oozie-auth-token", jvmName + "tmp", new File(System.getProperty("user.home")));
            tmpTokenFile.deleteOnExit();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpTokenFile), StandardCharsets.UTF_8);
            writer.write(authToken.toString());
            ((Writer)writer).close();
            Files.move(tmpTokenFile.toPath(), this.authTokenCacheFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            this.authTokenCacheFile.setReadable(false, false);
            this.authTokenCacheFile.setReadable(true, true);
            this.authTokenCacheFile.setWritable(true, true);
        }
        catch (IOException ioe) {
            this.authTokenCacheFile.delete();
        }
    }

    protected Authenticator getAuthenticator() throws OozieClientException {
        if (this.authOption != null) {
            try {
                Class<? extends Authenticator> authClass = this.getAuthenticators().get(this.authOption.toUpperCase());
                if (authClass == null) {
                    throw new OozieClientException("AUTHENTICATION", "Authenticator class not found [" + authClass + "]");
                }
                return authClass.newInstance();
            }
            catch (IllegalArgumentException iae) {
                throw new OozieClientException("AUTHENTICATION", "Invalid options provided for auth: " + this.authOption + ", (" + (Object)((Object)AuthType.KERBEROS) + " or " + (Object)((Object)AuthType.SIMPLE) + " or " + (Object)((Object)AuthType.BASIC) + " expected.)");
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new OozieClientException("AUTHENTICATION", "Could not instantiate Authenticator for option [" + this.authOption + "], " + ex.getMessage(), ex);
            }
        }
        String className = System.getProperty(AUTHENTICATOR_CLASS_SYS_PROP, KerberosAuthenticator.class.getName());
        if (className != null) {
            try {
                Class<?> klass;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = klass = cl != null ? cl.loadClass(className) : this.getClass().getClassLoader().loadClass(className);
                if (klass == null) {
                    throw new OozieClientException("AUTHENTICATION", "Authenticator class not found [" + className + "]");
                }
                return (Authenticator)klass.newInstance();
            }
            catch (Exception ex) {
                throw new OozieClientException("AUTHENTICATION", "Could not instantiate Authenticator [" + className + "], " + ex.getMessage(), ex);
            }
        }
        throw new OozieClientException("AUTHENTICATION", "Authenticator class not found [" + className + "]");
    }

    protected Map<String, Class<? extends Authenticator>> getAuthenticators() {
        HashMap<String, Class<? extends Authenticator>> authClasses = new HashMap<String, Class<? extends Authenticator>>();
        authClasses.put(AuthType.KERBEROS.toString(), KerberosAuthenticator.class);
        authClasses.put(AuthType.SIMPLE.toString(), PseudoAuthenticator.class);
        authClasses.put(AuthType.BASIC.toString(), BasicAuthenticator.class);
        authClasses.put(null, KerberosAuthenticator.class);
        return authClasses;
    }

    public String getAuthOption() {
        return this.authOption;
    }

    public static enum AuthType {
        KERBEROS,
        SIMPLE,
        BASIC;

    }
}

