/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.utils;

import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class FileUtil {
    private static final String BIN_DIR_NAME = ".app_idp";
    private static final String IDP_SERVER_SOCK_NAME = ".akless_idp.sock";
    private static final String IDP_CORE_BACKUP_TOKEN_PATTERN = "akless_backup_idtoken*";

    public static String getOsTempDir() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            String envTmpDir = System.getenv("TEMP");
            return envTmpDir != null && !envTmpDir.isEmpty() ? envTmpDir : System.getProperty("java.io.tmpdir");
        }
        return "/var/tmp";
    }

    public static String getAndMakeBinDir() throws IdpException {
        String baseDir;
        String envDir = System.getenv("APP_IDP_BIN_DIR");
        if (envDir != null && FileUtil.checkFileRwxPerm(envDir)) {
            return envDir;
        }
        String binDirPath = Paths.get(FileUtil.getOsTempDir(), BIN_DIR_NAME).toString();
        File binDir = new File(binDirPath);
        if (!binDir.exists() || !FileUtil.checkFileRwxPerm(binDirPath)) {
            if (FileUtil.mkdirAll(binDir.toPath(), "rwxrwxrwx") && FileUtil.checkFileRwxPerm(binDirPath)) {
                return binDirPath;
            }
        } else {
            File sockPath = new File(binDir, IDP_SERVER_SOCK_NAME);
            if (FileUtil.checkSockExisted(sockPath)) {
                return binDirPath;
            }
            class FileInfo {
                Path path;
                boolean r;
                boolean w;
                boolean x;

                public FileInfo(Path path, boolean r, boolean w, boolean x) {
                    this.path = path;
                    this.r = r;
                    this.w = w;
                    this.x = x;
                }
            }
            ArrayList<FileInfo> fis = new ArrayList<FileInfo>(Arrays.asList(new FileInfo(Paths.get(binDirPath, "logs"), true, true, true), new FileInfo(Paths.get(binDirPath, ".akless_idp.start"), true, false, false), new FileInfo(Paths.get(binDirPath, ".akless_idp.proc"), true, false, false)));
            try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(binDir.toPath(), IDP_CORE_BACKUP_TOKEN_PATTERN);){
                for (Path path : stream2) {
                    fis.add(new FileInfo(path, true, true, false));
                }
            }
            catch (Exception stream2) {
                // empty catch block
            }
            boolean valid = true;
            for (FileInfo fi : fis) {
                if (!fi.path.toFile().exists() || FileUtil.checkFilePerm(fi.path.toString(), fi.r, fi.w, fi.x)) continue;
                valid = false;
                break;
            }
            if (valid) {
                return binDirPath;
            }
        }
        if ((baseDir = System.getenv("HOME")) != null && FileUtil.mkdirAll((binDir = new File(binDirPath = Paths.get(baseDir, BIN_DIR_NAME).toString())).toPath(), "rwxr-xr-x") && FileUtil.checkFileRwxPerm(binDirPath)) {
            return binDirPath;
        }
        throw new IdpException(IdpErrorCode.GENERATE_IDP_TEMP_DIR_FAILED, new Object[0]);
    }

    public static boolean checkFileRwxPerm(String path) {
        return FileUtil.checkFilePerm(path, true, true, true);
    }

    public static boolean checkFilePerm(String path, boolean r, boolean w, boolean x) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        boolean valid = true;
        if (r) {
            boolean bl = valid = valid && file.canRead();
        }
        if (w) {
            boolean bl = valid = valid && file.canWrite();
        }
        if (x) {
            valid = valid && file.canExecute();
        }
        return valid;
    }

    public static boolean mkdirAll(Path path, String perm) {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("win")) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString(perm);
                Files.createDirectories(path, PosixFilePermissions.asFileAttribute(perms));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkSockExisted(File sockFile) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return true;
        }
        return sockFile.exists();
    }
}

