/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.shaded.com.google.common.base;

import com.aliyun.akless.idprovider.shaded.com.google.common.annotations.GwtCompatible;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Preconditions;
import com.aliyun.akless.idprovider.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.aliyun.akless.idprovider.shaded.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import java.util.Iterator;
import java.util.NoSuchElementException;

@GwtCompatible
abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    @NullableDecl
    private T next;

    protected AbstractIterator() {
    }

    protected abstract T computeNext();

    @NullableDecl
    @CanIgnoreReturnValue
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

