/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.shaded.com.github.rholder.retry;

import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Attempt;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.AttemptTimeLimiter;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.AttemptTimeLimiters;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.BlockStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.BlockStrategy;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryListener;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Retryer;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.StopStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.StopStrategy;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.WaitStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.WaitStrategy;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Preconditions;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Predicate;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Predicates;
import com.aliyun.akless.idprovider.shaded.javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

public class RetryerBuilder<V> {
    private AttemptTimeLimiter<V> attemptTimeLimiter;
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private BlockStrategy blockStrategy;
    private Predicate<Attempt<V>> rejectionPredicate = Predicates.alwaysFalse();
    private List<RetryListener> listeners = new ArrayList<RetryListener>();

    private RetryerBuilder() {
    }

    public static <V> RetryerBuilder<V> newBuilder() {
        return new RetryerBuilder<V>();
    }

    public RetryerBuilder<V> withRetryListener(@Nonnull RetryListener listener) {
        Preconditions.checkNotNull(listener, "listener may not be null");
        this.listeners.add(listener);
        return this;
    }

    public RetryerBuilder<V> withWaitStrategy(@Nonnull WaitStrategy waitStrategy) throws IllegalStateException {
        Preconditions.checkNotNull(waitStrategy, "waitStrategy may not be null");
        Preconditions.checkState(this.waitStrategy == null, "a wait strategy has already been set %s", new Object[]{this.waitStrategy});
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RetryerBuilder<V> withStopStrategy(@Nonnull StopStrategy stopStrategy) throws IllegalStateException {
        Preconditions.checkNotNull(stopStrategy, "stopStrategy may not be null");
        Preconditions.checkState(this.stopStrategy == null, "a stop strategy has already been set %s", new Object[]{this.stopStrategy});
        this.stopStrategy = stopStrategy;
        return this;
    }

    public RetryerBuilder<V> withBlockStrategy(@Nonnull BlockStrategy blockStrategy) throws IllegalStateException {
        Preconditions.checkNotNull(blockStrategy, "blockStrategy may not be null");
        Preconditions.checkState(this.blockStrategy == null, "a block strategy has already been set %s", new Object[]{this.blockStrategy});
        this.blockStrategy = blockStrategy;
        return this;
    }

    public RetryerBuilder<V> withAttemptTimeLimiter(@Nonnull AttemptTimeLimiter<V> attemptTimeLimiter) {
        Preconditions.checkNotNull(attemptTimeLimiter);
        this.attemptTimeLimiter = attemptTimeLimiter;
        return this;
    }

    public RetryerBuilder<V> retryIfException() {
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new ExceptionClassPredicate(Exception.class));
        return this;
    }

    public RetryerBuilder<V> retryIfRuntimeException() {
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new ExceptionClassPredicate(RuntimeException.class));
        return this;
    }

    public RetryerBuilder<V> retryIfExceptionOfType(@Nonnull Class<? extends Throwable> exceptionClass) {
        Preconditions.checkNotNull(exceptionClass, "exceptionClass may not be null");
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new ExceptionClassPredicate(exceptionClass));
        return this;
    }

    public RetryerBuilder<V> retryIfException(@Nonnull Predicate<Throwable> exceptionPredicate) {
        Preconditions.checkNotNull(exceptionPredicate, "exceptionPredicate may not be null");
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new ExceptionPredicate(exceptionPredicate));
        return this;
    }

    public RetryerBuilder<V> retryIfResult(@Nonnull Predicate<V> resultPredicate) {
        Preconditions.checkNotNull(resultPredicate, "resultPredicate may not be null");
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new ResultPredicate<V>(resultPredicate));
        return this;
    }

    public Retryer<V> build() {
        AttemptTimeLimiter theAttemptTimeLimiter = this.attemptTimeLimiter == null ? AttemptTimeLimiters.noTimeLimit() : this.attemptTimeLimiter;
        StopStrategy theStopStrategy = this.stopStrategy == null ? StopStrategies.neverStop() : this.stopStrategy;
        WaitStrategy theWaitStrategy = this.waitStrategy == null ? WaitStrategies.noWait() : this.waitStrategy;
        BlockStrategy theBlockStrategy = this.blockStrategy == null ? BlockStrategies.threadSleepStrategy() : this.blockStrategy;
        return new Retryer(theAttemptTimeLimiter, theStopStrategy, theWaitStrategy, theBlockStrategy, this.rejectionPredicate, this.listeners);
    }

    private static final class ExceptionPredicate<V>
    implements Predicate<Attempt<V>> {
        private Predicate<Throwable> delegate;

        public ExceptionPredicate(Predicate<Throwable> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean apply(Attempt<V> attempt) {
            if (!attempt.hasException()) {
                return false;
            }
            return this.delegate.apply(attempt.getExceptionCause());
        }
    }

    private static final class ResultPredicate<V>
    implements Predicate<Attempt<V>> {
        private Predicate<V> delegate;

        public ResultPredicate(Predicate<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean apply(Attempt<V> attempt) {
            if (!attempt.hasResult()) {
                return false;
            }
            V result = attempt.getResult();
            return this.delegate.apply(result);
        }
    }

    private static final class ExceptionClassPredicate<V>
    implements Predicate<Attempt<V>> {
        private Class<? extends Throwable> exceptionClass;

        public ExceptionClassPredicate(Class<? extends Throwable> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public boolean apply(Attempt<V> attempt) {
            if (!attempt.hasException()) {
                return false;
            }
            return this.exceptionClass.isAssignableFrom(attempt.getExceptionCause().getClass());
        }
    }
}

