/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.provider;

import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.CaCerts;
import com.aliyun.akless.idprovider.provider.AklessCredentialProvider;
import com.aliyun.akless.idprovider.provider.IAklessCertProvider;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.util.HashSet;
import java.util.Set;

public class AklessCertProvider
extends AklessCredentialProvider
implements IAklessCertProvider {
    private static final Set<String> executed = new HashSet<String>();
    protected final String caller;

    public AklessCertProvider(String caller) {
        this.caller = caller;
        this.checkTokenRetrievalOnce();
    }

    @Override
    public CaCerts getCerts() throws IdpException {
        return this.accessorProxy.getCerts(this.caller);
    }

    @Override
    public CaCerts refreshCerts() throws IdpException {
        return this.accessorProxy.refreshCerts(this.caller);
    }

    protected synchronized void checkTokenRetrievalOnce() throws IdpException {
        if (!executed.contains(this.caller)) {
            this.accessorProxy.getCerts(this.caller, Config.GRPC_FIRST_GET_CREDENTIAL_TIMEOUT_MILLIS);
            executed.add(this.caller);
        }
    }
}

