/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.provider;

import com.aliyun.akless.idprovider.enums.TokenCredType;
import com.aliyun.akless.idprovider.enums.TokenSignAlg;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.OIDCToken;
import com.aliyun.akless.idprovider.provider.AklessIDTokenProvider;

public class AklessAssumptionIDTokenProvider
extends AklessIDTokenProvider {
    private final String sourceNamespace;
    private final String sourceAppName;
    private final String sourceAppGroup;
    private final String sourceAppEnv;

    public AklessAssumptionIDTokenProvider(String sourceAppName, String sourceAppGroup, String sourceAppEnv, String targetService) {
        this("aone", sourceAppName, sourceAppGroup, sourceAppEnv, targetService);
    }

    public AklessAssumptionIDTokenProvider(String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv, String targetService) {
        super(targetService, TokenSignAlg.SIGN_ALG_RSA);
        this.sourceNamespace = sourceNamespace;
        this.sourceAppName = sourceAppName;
        this.sourceAppGroup = sourceAppGroup;
        this.sourceAppEnv = sourceAppEnv;
    }

    @Override
    public OIDCToken getIDToken() throws IdpException {
        return this.accessorProxy.getIDTokenOnAssumptionForApp(this.sourceNamespace, this.sourceAppName, this.sourceAppGroup, this.sourceAppEnv, this.tokenFactor, false);
    }

    @Override
    public OIDCToken refreshIDToken() throws IdpException {
        return this.accessorProxy.getIDTokenOnAssumptionForApp(this.sourceNamespace, this.sourceAppName, this.sourceAppGroup, this.sourceAppEnv, this.tokenFactor, true);
    }

    @Override
    public OIDCToken getIDTokenOnBehalf(TokenCredType sourceCredentialType, String sourceCredential) throws IdpException {
        throw new IdpException(IdpErrorCode.UNSUPPORTED_METHOD, "getIDTokenOnBehalf not supported by assumption provider");
    }

    @Override
    public OIDCToken getIDTokenOnAssumption(String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv) throws IdpException {
        throw new IdpException(IdpErrorCode.UNSUPPORTED_METHOD, "getIDTokenOnAssumption not supported by assumption provider");
    }

    @Override
    public OIDCToken getIDTokenOnAssumptionForEmp(String empId) throws IdpException {
        throw new IdpException(IdpErrorCode.UNSUPPORTED_METHOD, "getIDTokenOnAssumptionForEmp not supported by assumption provider");
    }
}

