/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.errors;

public enum IdpErrorCode {
    SUCCESS("Success", false),
    ILLEGAL_PARAM("Illegal parameter: %s", false),
    UNSUPPORTED_PLATFORM("Unsupported platform: %s", true),
    UNSUPPORTED_METHOD("Unsupported method: %s", false),
    INIT_ENV_CONFIG_FAILED("Failed to init env config: %s", false),
    RETRIEVE_TOKEN_FAILED("Failed to retrieve %s ID token against target service %s: %s", false),
    REFRESH_TOKEN_FAILED("Failed to refresh %s ID token against target service %s: %s", false),
    GET_TOKEN_ON_BEHALF_FAILED("Failed to get ID token on behalf against target service %s: %s", false),
    GET_TOKEN_ON_ASSUMPTION_FOR_APP_FAILED("Failed to get ID token on assumption for application against namespace %s, app name: %s, app group: %s, app env: %s and target service %s: %s", false),
    GET_TOKEN_ON_ASSUMPTION_FOR_EMP_FAILED("Failed to get ID token on assumption for employee against employee id %s and target service %s: %s", false),
    EXIT_PEER_SERVER_FAILED("Failed to exit peer server: %s", false),
    RETRIEVE_CACERTS_FAILED("Failed to retrieve ca certs: %s", false),
    REFRESH_CACERTS_FAILED("Failed to refresh ca certs: %s", false),
    LAUNCH_IDP_SERVER_FAILED("Failed to launch idp server: %s", true),
    DAEMONIZE_IDP_SERVER_FAILED("Failed to daemonize idp server", true),
    SPAWN_UDS_LISTENER_FAILED("Idp server failed to spawn unix socket listener", true),
    SPAWN_UDS_WATCHER_FAILED("Idp server failed to spawn unix socket watcher", true),
    IDP_SERVER_NOT_EXECUTABLE("failed to turn idp server to an executable: %s", true),
    IDP_SERVER_OUT_OF_DATE("idp server was out-of-date after restart: %s", true),
    GRPC_SERVICE_NOT_READY("Grpc service %s not ready: %s", true),
    CREATE_GRPC_ACCESSOR_FAILED("Failed to create grpc accessor: %s", true),
    CREATE_GRPC_CHANNEL_FAILED("failed to create grpc channel: %s", true),
    GRPC_SERVICE_UNRESPONSIVE("Grpc service unresponsive because of: %s, please check if startup successfully", false),
    GENERATE_IDP_TEMP_DIR_FAILED("Failed to generate temp dir for hosting idp files", true);

    public final String message;
    public final boolean fatal;

    private IdpErrorCode(String message, boolean fatal) {
        this.message = message;
        this.fatal = fatal;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFatal() {
        return this.fatal;
    }
}

