/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.enums;

import java.util.HashMap;
import java.util.Map;

public enum TokenSignAlg {
    SIGN_ALG_RSA(0, "RS256"),
    SIGN_ALG_HMAC(1, "HS256");

    private final Integer code;
    private final String alg;
    private static final Map<String, TokenSignAlg> valueMap;

    public static TokenSignAlg valueOfAlg(String alg) {
        return valueMap.get(alg);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getAlg() {
        return this.alg;
    }

    private TokenSignAlg(Integer code, String alg) {
        this.code = code;
        this.alg = alg;
    }

    static {
        valueMap = new HashMap<String, TokenSignAlg>();
        for (TokenSignAlg valueEnum : TokenSignAlg.values()) {
            valueMap.put(valueEnum.alg, valueEnum);
        }
    }
}

