/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.daemon;

import com.aliyun.akless.idprovider.accessor.AccessorProxy;
import com.aliyun.akless.idprovider.enums.IdpHealthStatus;
import com.aliyun.akless.idprovider.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpTaskScheduler {
    private static final Logger logger = LoggerFactory.getLogger(IdpTaskScheduler.class);
    private static final long maxCheckHealthSuccessiveFailureCnt = 15L;
    private final ScheduledExecutorService executor;
    private final SynchronousQueue<Boolean> illnessChan = new SynchronousQueue();
    private final SynchronousQueue<Boolean> runChan = new SynchronousQueue();
    private long checkHealthSuccessiveFailureCnt = 0L;

    public IdpTaskScheduler() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("akless-idp-daemon", true));
    }

    public void run() {
        this.executor.scheduleWithFixedDelay(this::schedule, 0L, Config.CHECK_HEALTH_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
    }

    public void waitForError() {
        try {
            this.illnessChan.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resume(boolean success) {
        try {
            if (success) {
                this.checkHealthSuccessiveFailureCnt = 0L;
            }
            this.runChan.put(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void schedule() {
        try {
            AccessorProxy accessorProxy = AccessorProxy.getAccessor();
            if (accessorProxy.checkHealth(false).getStatus() == IdpHealthStatus.IDP_UP_TO_DATE) {
                this.checkHealthSuccessiveFailureCnt = 0L;
                return;
            }
            if (this.checkHealthSuccessiveFailureCnt++ <= 15L) {
                return;
            }
            this.illnessChan.put(true);
            this.runChan.take();
        }
        catch (Exception e) {
            logger.error("failed on idp-server keep-alive task scheduling: {}", (Object)e.toString());
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

