/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.daemon;

import com.aliyun.akless.idprovider.daemon.IDaemonLauncher;
import com.aliyun.akless.idprovider.daemon.UnixDaemonLauncher;
import com.aliyun.akless.idprovider.daemon.WindowsDaemonLauncher;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;

public class IdpDaemonManager {
    private final IDaemonLauncher launcher;

    public IdpDaemonManager() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            this.launcher = new WindowsDaemonLauncher();
        } else if (osName.contains("linux") || osName.contains("mac")) {
            this.launcher = new UnixDaemonLauncher();
        } else {
            throw new IdpException(IdpErrorCode.UNSUPPORTED_PLATFORM, osName);
        }
    }

    public void restart() throws Exception {
        try {
            this.launcher.preExecute();
            this.launcher.launch();
        }
        finally {
            this.launcher.postExecute();
        }
    }
}

