/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.daemon;

import com.aliyun.akless.idprovider.accessor.AccessorProxy;
import com.aliyun.akless.idprovider.daemon.IDaemonLauncher;
import com.aliyun.akless.idprovider.enums.IdpHealthResult;
import com.aliyun.akless.idprovider.enums.IdpHealthStatus;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.shaded.com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDaemonLauncher
implements IDaemonLauncher {
    private static final Logger logger = LoggerFactory.getLogger(BaseDaemonLauncher.class);
    protected static final String binName = "idp-server";
    private long launchTimes = 0L;
    protected boolean daemonSelfManage = true;

    @Override
    public void launch() throws Exception {
        boolean restartRequired;
        block12: {
            AccessorProxy accessorProxy;
            restartRequired = false;
            try {
                accessorProxy = AccessorProxy.getAccessor();
            }
            catch (Exception e) {
                restartRequired = true;
                break block12;
            }
            IdpHealthResult healthResult = accessorProxy.checkHealth(true);
            if (healthResult.getStatus() != IdpHealthStatus.IDP_UP_TO_DATE) {
                restartRequired = true;
                if (healthResult.getStatus() == IdpHealthStatus.IDP_OUT_OF_DATE) {
                    try {
                        accessorProxy.exitPeer();
                        logger.info("succeed to exit running idp server...");
                    }
                    catch (Exception e) {
                        logger.warn("failed to exit running idp server: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        if (!restartRequired) {
            logger.info("skip restarting idp daemon due to sort of reasons...");
            return;
        }
        logger.info("prepare to start idp daemon...");
        File targetBin = this.generateExecutable();
        ArrayList<String> args = Lists.newArrayList(targetBin.getAbsolutePath(), "-d", "-l", "java");
        if (this.daemonSelfManage) {
            args.add("-c");
        }
        args.add("-o");
        String cloudProxySocksHost = System.getProperty("socksProxyHost");
        String cloudProxySocksPort = System.getProperty("socksProxyPort");
        if (cloudProxySocksHost != null && cloudProxySocksPort != null) {
            String cloudProxyAddr = String.format("%s:%s", cloudProxySocksHost, cloudProxySocksPort);
            logger.info("cloud proxy mode enabled with socks proxy and addr {}", (Object)cloudProxyAddr);
            Collections.addAll(args, "--cloud-proxy-mode", "Socks");
            Collections.addAll(args, "--cloud-proxy-addr", cloudProxyAddr);
        }
        HashMap<String, String> envPair = new HashMap<String, String>(System.getenv());
        if (this.launchTimes > 0L) {
            envPair.put("IDP_REINIT", "true");
        }
        this.forkNewDaemon(targetBin.getAbsolutePath(), args, envPair);
        AccessorProxy accessorProxy = AccessorProxy.getAccessor();
        IdpHealthResult healthResult = accessorProxy.checkHealth(true);
        if (healthResult.getStatus() == IdpHealthStatus.IDP_UNAVAILABLE) {
            throw new IdpException(IdpErrorCode.GRPC_SERVICE_NOT_READY, binName, String.format("connection still not ready after idp-server launched: %s", healthResult.getReason()));
        }
        if (healthResult.getStatus() == IdpHealthStatus.IDP_OUT_OF_DATE) {
            throw new IdpException(IdpErrorCode.IDP_SERVER_OUT_OF_DATE, healthResult.getReason());
        }
        logger.info("succeed to start idp daemon for {} time...", (Object)this.launchTimes++);
    }

    protected abstract File generateExecutable() throws Exception;

    protected abstract void forkNewDaemon(String var1, List<String> var2, Map<String, String> var3) throws Exception;
}

